/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.cover;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.cover.BannerRo;
import com.depotnearby.common.util.RedisUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Component;

@Component
public class BannerRedisDao
extends CommonRedisDao {
    public void save(BannerRo ro) {
        this.zadd(RedisKeyGenerator.Banner.getBannerInCategorySortSetKey(ro.getCategoryId()), ro.getIdx().intValue(), RedisUtil.toByteArray((Long)ro.getId()));
        this.hmset(RedisKeyGenerator.Banner.getBannerHashKey(ro.getId()), ro.toMap());
    }

    public void update(BannerRo ro, Integer wornCategoryId) {
        this.zrem(RedisKeyGenerator.Banner.getBannerInCategorySortSetKey(wornCategoryId), new byte[][]{RedisUtil.toByteArray((Long)ro.getId())});
        this.zadd(RedisKeyGenerator.Banner.getBannerInCategorySortSetKey(ro.getCategoryId()), ro.getIdx().intValue(), RedisUtil.toByteArray((Long)ro.getId()));
        this.hmset(RedisKeyGenerator.Banner.getBannerHashKey(ro.getId()), ro.toMap());
    }

    public void delete(Integer categoryId, Long id) {
        this.zrem(RedisKeyGenerator.Banner.getBannerInCategorySortSetKey(categoryId), new byte[][]{RedisUtil.toByteArray((Long)id)});
        this.del(RedisKeyGenerator.Banner.getBannerHashKey(id));
    }

    public BannerRo get(Long id) {
        if (id == null) {
            return null;
        }
        Map<byte[], byte[]> map = this.hgetAll(RedisKeyGenerator.Banner.getBannerHashKey(id));
        if (MapUtils.isNotEmpty(map)) {
            BannerRo ro = new BannerRo();
            ro.fromMap(map);
            return ro;
        }
        return null;
    }

    public List<BannerRo> findByCategory(Integer categoryId) {
        ArrayList<BannerRo> list = new ArrayList<BannerRo>();
        List ids = RedisUtil.bytesSetToLongList(super.zRange(RedisKeyGenerator.Banner.getBannerInCategorySortSetKey(categoryId), 0L, -1L));
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            for (Long id : ids) {
                BannerRo ro = this.get(id);
                if (ro == null) continue;
                list.add(ro);
            }
        }
        return list;
    }

    public Long getCount(Integer categoryId) {
        return this.zCard(RedisKeyGenerator.Banner.getBannerInCategorySortSetKey(categoryId));
    }
}

