/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.cover;

import com.depotnearby.bean.PageControl;
import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.model.CoverClientType;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.bean.RoConverter;
import com.depotnearby.common.ro.cover.CoverRo;
import com.depotnearby.common.util.RedisUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codelogger.utils.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class CoverRedisDao
extends CommonRedisDao {
    public List<CoverRo> getAllCoverRos() {
        Set<byte[]> idBytesSet = this.zrevrange(RedisKeyGenerator.Cover.getAllCoverSortSetKey(), 0L, -1L);
        return this.getCoverRos(RedisUtil.bytesSetToStringList(idBytesSet));
    }

    public List<CoverRo> getAllCoverRos(CoverClientType coverClientType) {
        Set<byte[]> idBytesSet = this.zrevrange(RedisKeyGenerator.Cover.getCoverClientSortSetKey(coverClientType.getValue()), 0L, -1L);
        return this.getCoverRos(RedisUtil.bytesSetToStringList(idBytesSet));
    }

    public List<CoverRo> getCoverRos(PageControl pageControl) {
        int pageSize = pageControl.getPageSize();
        int startIndex = Math.max(pageControl.getCurrentPage() - 1, 0) * pageSize;
        Set<byte[]> idBytesSet = this.zrevrange(RedisKeyGenerator.Cover.getAllCoverSortSetKey(), startIndex, startIndex + pageSize - 1);
        return this.getCoverRos(RedisUtil.bytesSetToStringList(idBytesSet));
    }

    public CoverRo getCoverRo(String coverId) {
        String coverKey = RedisKeyGenerator.Cover.getCoverHashKey(coverId);
        return CoverRo.fromDataMap(this.hgetAll(coverKey));
    }

    public List<CoverRo> getCoverRos(Collection<String> coverIds) {
        ArrayList covers = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(coverIds)) {
            ArrayList coverKes = Lists.newArrayList();
            for (String coverId : coverIds) {
                coverKes.add(RedisKeyGenerator.Cover.getCoverHashKey(coverId));
            }
            List coverDataMaps = this.pipeHgetall(coverKes);
            for (Object roMap : coverDataMaps) {
                covers.add(RoConverter.fromMap((Map)((Map)roMap), CoverRo.class));
            }
        }
        return covers;
    }

    public Long getCoverCount() {
        return this.zCard(RedisKeyGenerator.Cover.getAllCoverSortSetKey());
    }

    public void addCoverRo(CoverRo coverRo) {
        this.deleteCoverRo(coverRo.getId());
        this.zadd(RedisKeyGenerator.Cover.getAllCoverSortSetKey(), coverRo.getZIndex().intValue(), RedisUtil.toByteArray((String)coverRo.getId()));
        this.zadd(RedisKeyGenerator.Cover.getCoverCitySortSetKey(coverRo.getCityId()), coverRo.getZIndex().intValue(), RedisUtil.toByteArray((String)coverRo.getId()));
        this.zadd(RedisKeyGenerator.Cover.getCoverClientSortSetKey(coverRo.getClientType()), coverRo.getZIndex().intValue(), RedisUtil.toByteArray((String)coverRo.getId()));
        this.hmset(RedisKeyGenerator.Cover.getCoverHashKey(coverRo.getId()), coverRo.toMap());
    }

    public void deleteCoverRo(String coverId) {
        this.zrem(RedisKeyGenerator.Cover.getAllCoverSortSetKey(), new byte[][]{RedisUtil.toByteArray((String)coverId)});
        CoverRo coverRo = this.getCoverRo(coverId);
        if (coverRo != null) {
            this.deleteCoverCitySetKey(coverRo);
            this.zrem(RedisKeyGenerator.Cover.getCoverClientSortSetKey(coverRo.getClientType()), new byte[][]{RedisUtil.toByteArray((String)coverId)});
            this.del(RedisKeyGenerator.Cover.getCoverHashKey(coverId));
        }
    }

    private void deleteCoverCitySetKey(CoverRo coverRo) {
        this.zrem(RedisKeyGenerator.Cover.getCoverCitySortSetKey(coverRo.getCityId()), new byte[][]{RedisUtil.toByteArray((String)coverRo.getId())});
    }

    public List<CoverRo> getCoverRosByCity(Integer cityId) {
        int size;
        Set<byte[]> idSet = this.zRange(RedisKeyGenerator.Cover.getCoverCitySortSetKey(cityId), 0L, -1L);
        if (idSet != null && (size = idSet.size()) > 0) {
            ArrayList<CoverRo> result = new ArrayList<CoverRo>(size);
            for (byte[] b : idSet) {
                CoverRo ro = this.getCoverRo(RedisUtil.byteArrayToStr((byte[])b));
                if (ro == null) continue;
                result.add(ro);
            }
            return result;
        }
        return Lists.newArrayList();
    }
}

