/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.cover;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.cover.ProgramRo;
import com.depotnearby.common.util.RedisUtil;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ProgramRedisDao
extends CommonRedisDao {
    public void addProgramRo(ProgramRo programRo) {
        this.zadd(RedisKeyGenerator.Program.getJoinProgramSortSetKeyByCoverId(programRo.getCoverId()), programRo.getIdx().intValue(), RedisUtil.toByteArray((String)programRo.getId()));
        this.hmset(RedisKeyGenerator.Program.getProgramHashKey(programRo.getId()), programRo.toMap());
    }

    public String[] getProgramIdsByCoverId(String coverId) {
        Set<byte[]> idBytesSet = this.zrevrange(RedisKeyGenerator.Program.getJoinProgramSortSetKeyByCoverId(coverId), 0L, -1L);
        return RedisUtil.bytesSetToStringArray(idBytesSet);
    }

    public ProgramRo getProgramRo(String programId) {
        String programKey = RedisKeyGenerator.Program.getProgramHashKey(programId);
        return ProgramRo.fromDataMap(this.hgetAll(programKey));
    }

    public void deleteProgramRosByCoverId(String coverId) {
        Object[] programIdsByCoverId = this.getProgramIdsByCoverId(coverId);
        if (ArrayUtils.isNotEmpty((Object[])programIdsByCoverId)) {
            for (Object programId : programIdsByCoverId) {
                this.del(RedisKeyGenerator.Program.getProgramHashKey((String)programId));
            }
        }
        this.del(RedisKeyGenerator.Program.getJoinProgramSortSetKeyByCoverId(coverId));
    }

    public void deleteProgramRo(String programId) {
        ProgramRo programRo = this.getProgramRo(programId);
        if (programRo != null) {
            this.zrem(RedisKeyGenerator.Program.getJoinProgramSortSetKeyByCoverId(programRo.getCoverId()), new byte[][]{RedisUtil.toByteArray((String)programId)});
            this.del(RedisKeyGenerator.Program.getProgramHashKey(programId));
        }
    }
}

