/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.depot;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.bean.RoConverter;
import com.depotnearby.common.ro.bean.RoKeyGenerator;
import com.depotnearby.common.ro.depot.DepotRo;
import com.depotnearby.common.util.RedisUtil;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.codelogger.utils.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class DepotRedisDao
extends CommonRedisDao {
    public DepotRo save(DepotRo depotRo) {
        this.hmset(RoKeyGenerator.getHashKey(depotRo.getClass(), (Serializable)((Object)depotRo.getId())), RoConverter.toMap((Object)depotRo));
        this.zadd(RoKeyGenerator.getIdSortedSetKey(depotRo.getClass()), System.currentTimeMillis(), RedisUtil.toByteArray((String)depotRo.getId()));
        this.set(RedisKeyGenerator.Depot.getMcuCodeToDepotIdKey(depotRo.getMcuCode()), RedisUtil.toByteArray((String)depotRo.getId()));
        this.addDepotIdToAreaSet(depotRo.getAreaNo(), depotRo.getId());
        return depotRo;
    }

    public DepotRo findOne(String depotId) {
        if (StringUtils.isBlank((CharSequence)depotId)) {
            return null;
        }
        return this.loadFromCacheOrCacheLoader("findOne", new CacheLoader<String, DepotRo>(){

            public DepotRo load(String key) throws Exception {
                return (DepotRo)RoConverter.fromMap((Map)DepotRedisDao.this.hgetAll(key), DepotRo.class);
            }
        }, RoKeyGenerator.getHashKey(DepotRo.class, (Serializable)((Object)depotId)), TimeUnit.SECONDS, 5L);
    }

    public void delete(String depotId) {
        this.del(RoKeyGenerator.getHashKey(DepotRo.class, (Serializable)((Object)depotId)));
        this.zrem(RoKeyGenerator.getIdSortedSetKey(DepotRo.class), depotId);
    }

    public List<DepotRo> findAll() {
        Set<byte[]> idKeys = this.zRange(RoKeyGenerator.getIdSortedSetKey(DepotRo.class), 0L, -1L);
        Object[] ids = RedisUtil.bytesSetToStringArray(idKeys);
        ArrayList depots = Lists.newArrayList();
        if (ArrayUtils.isNotEmpty((Object[])ids)) {
            ArrayList roHashKeys = Lists.newArrayList();
            for (Object id : ids) {
                roHashKeys.add(RoKeyGenerator.getHashKey(DepotRo.class, (Serializable)id));
            }
            List roMaps = this.pipeHgetall(roHashKeys);
            for (Object roMap : roMaps) {
                depots.add(RoConverter.fromMap((Map)((Map)roMap), DepotRo.class));
            }
        }
        return depots;
    }

    public String getDepotIdByMcuCode(String mcuCode) {
        return RedisUtil.byteArrayToStr((byte[])this.get(RedisKeyGenerator.Depot.getMcuCodeToDepotIdKey(mcuCode)));
    }

    public List<DepotRo> findDepotRosByAreaNo(String areaNo) {
        ArrayList depotRos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)areaNo)) {
            for (byte[] depotId : this.smembers(RedisKeyGenerator.Depot.getAreaNoToDepotIdsSetKey(areaNo))) {
                DepotRo depotRo = this.findOne(RedisUtil.byteArrayToStr((byte[])depotId));
                if (depotRo == null) continue;
                depotRos.add(depotRo);
            }
        }
        return depotRos;
    }

    public void addDepotIdToAreaSet(String areaNo, String depotId) {
        if (StringUtils.isBlank((CharSequence)areaNo) || StringUtils.isBlank((CharSequence)depotId)) {
            return;
        }
        this.sadd(RedisKeyGenerator.Depot.getAreaNoToDepotIdsSetKey(areaNo), RedisUtil.toByteArray((String)depotId));
    }

    public void removeDepotIdFromAreaSet(String areaNo, String depotId) {
        if (StringUtils.isBlank((CharSequence)areaNo) || StringUtils.isBlank((CharSequence)depotId)) {
            return;
        }
        this.srem(RedisKeyGenerator.Depot.getAreaNoToDepotIdsSetKey(areaNo), RedisUtil.toByteArray((String)depotId));
    }

    public void addPartnerDepotIds(String depotId, Collection<String> partnerDepotIds) {
        if (StringUtils.isBlank((CharSequence)depotId) || CollectionUtils.isEmpty(partnerDepotIds)) {
            return;
        }
        this.pipeZadd(RedisKeyGenerator.Depot.getPartnerDepotSortedSetKey(), depotId.hashCode(), partnerDepotIds);
    }

    public Set<String> getPartnerDepotIdsByDepotId(String depotId) {
        if (StringUtils.isBlank((CharSequence)depotId)) {
            return Sets.newHashSet();
        }
        return this.zrangeByScore(RedisKeyGenerator.Depot.getPartnerDepotSortedSetKey(), depotId.hashCode(), depotId.hashCode());
    }

    public void removePartnerDepotIdsByDepotId(String depotId, Collection<String> partnerDepotIds) {
        if (StringUtils.isBlank((CharSequence)depotId) || CollectionUtils.isEmpty(partnerDepotIds)) {
            return;
        }
        this.pipeZrem(RedisKeyGenerator.Depot.getPartnerDepotSortedSetKey(), partnerDepotIds);
    }
}

