/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.info;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.info.NoticeRo;
import com.depotnearby.common.util.RedisUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Component;

@Component
public class NoticeRedisDao
extends CommonRedisDao {
    public void save(NoticeRo noticeRo) {
        this.hmset(RedisKeyGenerator.Notice.getNoticeHashKey(noticeRo.getId()), noticeRo.toMap());
    }

    public void addToUser(Long noticeId, Long userId) {
        this.zadd(RedisKeyGenerator.Notice.getUserNoticeSortSetKey(userId), noticeId.longValue(), RedisUtil.toByteArray((Long)noticeId));
    }

    public void addToUsers(Long noticeId, List<Long> userIds) {
        if (CollectionUtils.isNotEmpty(userIds)) {
            for (Long userId : userIds) {
                this.addToUser(noticeId, userId);
            }
        }
    }

    public NoticeRo get(Long noticeId) {
        if (noticeId == null) {
            return null;
        }
        Map<byte[], byte[]> map = this.hgetAll(RedisKeyGenerator.Notice.getNoticeHashKey(noticeId));
        if (MapUtils.isNotEmpty(map)) {
            NoticeRo ro = new NoticeRo();
            ro.fromMap(map);
            return ro;
        }
        return null;
    }

    public List<NoticeRo> findAfter(Long userId, Long noticeId) {
        List ids;
        ArrayList<NoticeRo> list = new ArrayList<NoticeRo>();
        String lastId = "0";
        if (noticeId != null) {
            lastId = "(" + noticeId.toString();
        }
        if (CollectionUtils.isNotEmpty((Collection)(ids = RedisUtil.stringSetToLongList(this.zrangeByScore(RedisKeyGenerator.Notice.getUserNoticeSortSetKey(userId), lastId, "+inf"))))) {
            for (Long id : ids) {
                NoticeRo ro = this.get(id);
                if (ro == null) continue;
                list.add(ro);
            }
        }
        return list;
    }

    public Long getRemainMSgCount(Long userId) {
        return super.zCard(RedisKeyGenerator.Notice.getUserNoticeSortSetKey(userId));
    }

    public void deleteAfter(Long userId, Long lastNoticeId) {
        super.zremrangeByScore(RedisKeyGenerator.Notice.getUserNoticeSortSetKey(userId), "-inf", "+inf");
    }
}

