/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.info;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.info.PromotionRo;
import com.depotnearby.common.util.RedisUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PromotionRedisDao
extends CommonRedisDao {
    private static final Logger logger = LoggerFactory.getLogger(PromotionRedisDao.class);

    public void save(PromotionRo promotionRo) {
        this.zadd(RedisKeyGenerator.Promotion.getAllPromotionSortSetKey(), promotionRo.getIdx().intValue(), RedisUtil.toByteArray((Long)promotionRo.getId()));
        this.hmset(RedisKeyGenerator.Promotion.getPromotionHashKey(promotionRo.getId()), promotionRo.toMap());
        logger.debug("Update system promotion latest update time to now.");
        this.set(RedisKeyGenerator.Promotion.getSystemLatestUpdateTimeHashKey(), RedisUtil.toByteArray((Date)new Date()));
    }

    public void delete(Long id) {
        this.zrem(RedisKeyGenerator.Promotion.getAllPromotionSortSetKey(), new byte[][]{RedisUtil.toByteArray((Long)id)});
        this.del(RedisKeyGenerator.Promotion.getPromotionHashKey(id));
    }

    public PromotionRo get(Long promotionId) {
        if (promotionId == null) {
            return null;
        }
        Map<byte[], byte[]> map = this.hgetAll(RedisKeyGenerator.Promotion.getPromotionHashKey(promotionId));
        if (MapUtils.isNotEmpty(map)) {
            PromotionRo ro = new PromotionRo();
            ro.fromMap(map);
            return ro;
        }
        return null;
    }

    public List<Long> getAllIds() {
        return RedisUtil.bytesSetToLongList(this.zRange(RedisKeyGenerator.Promotion.getAllPromotionSortSetKey(), 0L, -1L));
    }

    public List<PromotionRo> findAll() {
        ArrayList<PromotionRo> list = new ArrayList<PromotionRo>();
        List ids = RedisUtil.bytesSetToLongList(super.zrevrange(RedisKeyGenerator.Promotion.getAllPromotionSortSetKey(), 0L, -1L));
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            for (Long id : ids) {
                PromotionRo ro = this.get(id);
                if (ro == null) continue;
                list.add(ro);
            }
        }
        return list;
    }

    public Date getSystemLatestUpdateTime() {
        return this.parseDate(this.get(RedisKeyGenerator.Promotion.getSystemLatestUpdateTimeHashKey()));
    }

    public Date getUserLatestUpdateTime(Long userId) {
        return this.parseDate(this.get(RedisKeyGenerator.Promotion.getUserLatestUpdateTimeHashKey(userId)));
    }

    public void updateUserLatestFetchTime(Long userId) {
        this.set(RedisKeyGenerator.Promotion.getUserLatestUpdateTimeHashKey(userId), RedisUtil.toByteArray((Date)new Date()));
    }

    private Date parseDate(byte[] latestUpdateTimeDataBytes) {
        if (latestUpdateTimeDataBytes == null) {
            return null;
        }
        return RedisUtil.byteArrayToDate((byte[])latestUpdateTimeDataBytes);
    }
}

