/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.modulingcover;

import com.depotnearby.common.ro.modulingcover.ModulingProgramRO;
import com.depotnearby.common.util.RedisUtil;
import com.depotnearby.dao.redis.AbstractRedisDao;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ModulingProgramRedisDao
extends AbstractRedisDao<ModulingProgramRO, Long> {
    @Override
    public ModulingProgramRO save(ModulingProgramRO ro) {
        super.save(ro);
        super.zadd(this.getCoverProgramIdsSortedSetKey(ro.getCoverId()), System.currentTimeMillis(), RedisUtil.toByteArray((Long)ro.getId()));
        return ro;
    }

    @Override
    public void delete(Long programId) {
        ModulingProgramRO programRo = (ModulingProgramRO)this.findOne(programId);
        super.delete(programId);
        if (programRo != null) {
            super.zrem(this.getCoverProgramIdsSortedSetKey(programRo.getCoverId()), new byte[][]{RedisUtil.toByteArray((Long)programId)});
        }
    }

    public void deleteByCoverId(Long coverId) {
        Set<byte[]> programIds = super.zangeByScore(this.getCoverProgramIdsSortedSetKey(coverId), "-inf", "+inf");
        if (CollectionUtils.isEmpty(programIds)) {
            return;
        }
        for (byte[] programId : programIds) {
            this.delete(RedisUtil.byteArrayToLong((byte[])programId));
        }
    }

    public List<ModulingProgramRO> findByCoverId(Long coverId) {
        List coverIdBytes = RedisUtil.bytesSetToLongList(super.zangeByScore(this.getCoverProgramIdsSortedSetKey(coverId), "-inf", "+inf"));
        return this.findByIds(coverIdBytes);
    }

    private String getCoverProgramIdsSortedSetKey(Long coverId) {
        return super.getKeyByParams("cover_" + coverId + "_ids");
    }
}

