/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.mq;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.bean.RoConverter;
import com.depotnearby.common.ro.bean.RoKeyGenerator;
import com.depotnearby.common.util.RedisUtil;
import com.depotnearby.dao.redis.IMQRedisDao;
import com.depotnearby.ro.mq.MQMessageRo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codelogger.utils.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MQRedisDao")
public class MQRedisDao
extends CommonRedisDao
implements IMQRedisDao {
    private static final Logger logger = LoggerFactory.getLogger(MQRedisDao.class);

    public void addToWaitForProcessQueue(MQMessageRo mQMessageRo) {
        if (mQMessageRo == null) {
            return;
        }
        logger.debug("Add {} to mq message wait list.", (Object)mQMessageRo.getId());
        this.hmset(RoKeyGenerator.getHashKey(mQMessageRo.getClass(), (Serializable)((Object)mQMessageRo.getId())), RoConverter.toMap((Object)mQMessageRo));
        long nextProcessTime = mQMessageRo.getLatestProcessTime() + mQMessageRo.getRetryPeriod();
        this.zadd(RoKeyGenerator.getIdSortedSetKey(mQMessageRo.getClass()), nextProcessTime, RedisUtil.toByteArray((String)mQMessageRo.getId()));
    }

    public List<MQMessageRo> getMQMessageRosOfNeedProcess() {
        Set<String> idKeys = this.zrangeByScore(RoKeyGenerator.getIdSortedSetKey(MQMessageRo.class), 0L, System.currentTimeMillis());
        ArrayList mqMessageRos = Lists.newArrayList();
        if (ArrayUtils.isNotEmpty(idKeys)) {
            ArrayList roHashKeys = Lists.newArrayList();
            for (String id : idKeys) {
                if (this.zrank(RedisKeyGenerator.Message.getQueueOfProcessingKey(), RedisUtil.toByteArray((String)id)) == null) continue;
                logger.debug("Add {} to mq message processing list.", (Object)id);
                this.zadd(RedisKeyGenerator.Message.getQueueOfProcessingKey(), System.currentTimeMillis(), RedisUtil.toByteArray((String)id));
                roHashKeys.add(RoKeyGenerator.getHashKey(MQMessageRo.class, (Serializable)((Object)id)));
            }
            List roMaps = this.pipeHgetall(roHashKeys);
            for (Object roMap : roMaps) {
                mqMessageRos.add(RoConverter.fromMap((Map)((Map)roMap), MQMessageRo.class));
            }
        }
        return mqMessageRos;
    }

    public void markAsProcessed(MQMessageRo mqMessageRo) {
        logger.debug("Remove {} from mq message processing list.", (Object)mqMessageRo.getId());
        this.zrem(RoKeyGenerator.getIdSortedSetKey(mqMessageRo.getClass()), mqMessageRo.getId());
        this.zrem(RedisKeyGenerator.Message.getQueueOfProcessingKey(), mqMessageRo.getId());
        this.del(RoKeyGenerator.getHashKey(mqMessageRo.getClass(), (Serializable)((Object)mqMessageRo.getId())));
    }

    public void putBackToWaitForProcessQueue(MQMessageRo mqMessageRo) {
        this.zrem(RedisKeyGenerator.Message.getQueueOfProcessingKey(), mqMessageRo.getId());
    }
}

