/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.order;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.po.order.OrderItemPo;
import com.depotnearby.common.po.order.OrderPo;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.util.RedisUtil;
import com.depotnearby.util.DateTool;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class NuoMiLimitRedisDao
extends CommonRedisDao {
    private static final String FIELD_LIMIT = "LIMIT";
    private static final String FIELD_COUNT = "COUNT";

    public boolean isOutOfLimit(Integer cityCode, Long userId, String depotId, Long productId, Integer quantity) {
        if (StringUtils.isBlank((CharSequence)depotId) || productId == null || quantity == null || quantity < 1) {
            return false;
        }
        return this.isOutOfProductLimit(productId, quantity) || this.isOutOfUserPeriodLimit(userId, productId, quantity);
    }

    public void updateLimit(OrderPo order) {
        String depotId = order.getPriceDepot().getId();
        Long userId = order.getBuyerId();
        for (OrderItemPo item : order.getItems()) {
            Long productId = item.getProductId();
            Integer quantity = item.getQuantity();
            this.updateProductLimit(productId, quantity);
            this.updatePeriodLimit(userId, productId, quantity);
        }
    }

    public boolean isLimitCity(Integer cityCode) {
        return cityCode != null && cityCode != 0 && super.sismember(RedisKeyGenerator.Nuomi.getLimitCityCodeKey(), String.valueOf(cityCode).getBytes());
    }

    public boolean isLimit() {
        return this.exists(RedisKeyGenerator.Nuomi.getIsLimitKey());
    }

    public boolean isOutOfUserPeriodLimit(Long userId, Long productId, Integer quantity) {
        Integer limit = RedisUtil.byteArrayToInt((byte[])this.hget(RedisKeyGenerator.Nuomi.getProductLimitPeriodKey(productId), FIELD_LIMIT));
        if (limit == null) {
            return false;
        }
        Integer buyCount = RedisUtil.byteArrayToInt((byte[])this.hget(RedisKeyGenerator.Nuomi.getUserProductLimitPeriodKey(userId, productId), RedisKeyGenerator.Nuomi.getUserProductPeriodField(DateTool.getNowDate())));
        buyCount = buyCount == null ? 0 : buyCount;
        return buyCount + quantity > limit;
    }

    public void updatePeriodLimit(Long userId, Long productId, Integer quantity) {
        if (productId == null || quantity == null || quantity < 1) {
            return;
        }
        this.hincrBy(RedisKeyGenerator.Nuomi.getUserProductLimitPeriodKey(userId, productId), RedisKeyGenerator.Nuomi.getUserProductPeriodField(DateTool.getNowDate()).getBytes(), quantity.intValue());
    }

    public boolean isOutOfProductLimit(Long productId, Integer quantity) {
        Integer limit = RedisUtil.byteArrayToInt((byte[])this.hget(RedisKeyGenerator.Nuomi.getProductLimitKey(productId), FIELD_LIMIT));
        if (limit == null) {
            return false;
        }
        Integer count = RedisUtil.byteArrayToInt((byte[])this.hget(RedisKeyGenerator.Nuomi.getProductLimitKey(productId), FIELD_COUNT));
        return count != null && count + quantity > limit;
    }

    public void updateProductLimit(Long productId, Integer quantity) {
        this.hincrBy(RedisKeyGenerator.Nuomi.getProductLimitKey(productId), FIELD_COUNT.getBytes(), quantity.intValue());
    }
}

