/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.order;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.po.CommonStatus;
import com.depotnearby.common.po.order.OrderPo;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.bean.RoConverter;
import com.depotnearby.common.ro.bean.RoKeyGenerator;
import com.depotnearby.common.ro.order.OrderStockRo;
import com.depotnearby.common.util.RedisUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.codelogger.utils.ValueUtils;
import org.springframework.stereotype.Repository;

@Repository
public class OrderRedisDao
extends CommonRedisDao {
    public List<Long> getWaitForPayOrderIds(Long userId) {
        return RedisUtil.bytesSetToLongList(super.zrevrange(RedisKeyGenerator.Order.getWaitForPayOrderIdsSortSetKey(userId), 0L, -1L));
    }

    public List<Long> getWaitForReceiveOrderIds(Long userId) {
        return RedisUtil.bytesSetToLongList(super.zrevrange(RedisKeyGenerator.Order.getWaitForReceiveOrderIdsSortSetKey(userId), 0L, -1L));
    }

    public List<Long> getAllOrderIds(Long userId) {
        return RedisUtil.bytesSetToLongList(super.zrevrange(RedisKeyGenerator.Order.getAllOrderIdsSortSetKey(userId), 0L, -1L));
    }

    public List<Long> getAllOrderIds(Long userId, String lastFlag, int to) {
        Long score = super.zrevrank(RedisKeyGenerator.Order.getAllOrderIdsSortSetKey(userId), lastFlag.getBytes());
        long from = lastFlag == null ? 0L : (score == null ? 0L : score + 1L);
        return RedisUtil.bytesSetToLongList(super.zrevrange(RedisKeyGenerator.Order.getAllOrderIdsSortSetKey(userId), from, from + (long)to));
    }

    public List<Long> getFinishedOrderIds(Long userId, String lastFlag, int to) {
        Long score = null;
        if (!StringUtils.isBlank((String)lastFlag)) {
            score = super.zrevrank(RedisKeyGenerator.Order.getFinishedOrderIdsSortSetKey(userId), lastFlag.getBytes());
        }
        long from = lastFlag == null ? 0L : (score == null ? 0L : score + 1L);
        return RedisUtil.bytesSetToLongList(super.zrevrange(RedisKeyGenerator.Order.getFinishedOrderIdsSortSetKey(userId), from, from + (long)to));
    }

    public void create(Long userId, Long createTime, Long orderId, boolean needNotPay) {
        this.zadd(RedisKeyGenerator.Order.getAllOrderIdsSortSetKey(userId), createTime.longValue(), RedisUtil.toByteArray((Long)orderId));
        if (needNotPay) {
            this.zadd(RedisKeyGenerator.Order.getWaitForReceiveOrderIdsSortSetKey(userId), createTime.longValue(), RedisUtil.toByteArray((Long)orderId));
        } else {
            this.zadd(RedisKeyGenerator.Order.getWaitForPayOrderIdsSortSetKey(userId), createTime.longValue(), RedisUtil.toByteArray((Long)orderId));
        }
    }

    public void accept(Long userId, long time, Long orderId) {
        this.zrem(RedisKeyGenerator.Order.getWaitForPayOrderIdsSortSetKey(userId), new byte[][]{RedisUtil.toByteArray((Long)orderId)});
        this.zadd(RedisKeyGenerator.Order.getWaitForReceiveOrderIdsSortSetKey(userId), time, RedisUtil.toByteArray((Long)orderId));
    }

    public void reject(Long userId, Long orderId) {
        this.zrem(RedisKeyGenerator.Order.getWaitForPayOrderIdsSortSetKey(userId), new byte[][]{RedisUtil.toByteArray((Long)orderId)});
    }

    public void paid(Long userId, Long createTime, Long orderId) {
        this.zrem(RedisKeyGenerator.Order.getWaitForPayOrderIdsSortSetKey(userId), new byte[][]{RedisUtil.toByteArray((Long)orderId)});
        this.zadd(RedisKeyGenerator.Order.getWaitForReceiveOrderIdsSortSetKey(userId), createTime.longValue(), RedisUtil.toByteArray((Long)orderId));
    }

    public void finish(Long userId, Long createTime, Long orderId) {
        this.zrem(RedisKeyGenerator.Order.getWaitForReceiveOrderIdsSortSetKey(userId), new byte[][]{RedisUtil.toByteArray((Long)orderId)});
        this.zadd(RedisKeyGenerator.Order.getFinishedOrderIdsSortSetKey(userId), createTime.longValue(), RedisUtil.toByteArray((Long)orderId));
    }

    public void addOrderToPayLimitSortSet(Long orderId, Long paylimitTimeInMillis) {
        this.zadd(RedisKeyGenerator.Order.getPayLimitSortSetKey(), paylimitTimeInMillis.longValue(), RedisUtil.toByteArray((Long)orderId));
    }

    public void removeOrderFromPayLimitSortSet(Long orderId) {
        this.zrem(RedisKeyGenerator.Order.getPayLimitSortSetKey(), new byte[][]{RedisUtil.toByteArray((Long)orderId)});
    }

    public void removeWaitForPaySortSet(Long userId, Long orderId) {
        this.zrem(RedisKeyGenerator.Order.getWaitForPayOrderIdsSortSetKey(userId), new byte[][]{RedisUtil.toByteArray((Long)orderId)});
    }

    public void removeFinishedSortSet(Long userId, Long orderId) {
        this.zrem(RedisKeyGenerator.Order.getFinishedOrderIdsSortSetKey(userId), new byte[][]{RedisUtil.toByteArray((Long)orderId)});
    }

    public Set<byte[]> getPayExpireOrderId(long currentTimeMillis) {
        return this.zangeByScore(RedisKeyGenerator.Order.getPayLimitSortSetKey(), "0", String.valueOf(currentTimeMillis));
    }

    public void addWaitForAccept(OrderPo order) {
        super.zadd(RedisKeyGenerator.Order.getWaitForAcceptSortSetKey(), order.getCreateTime().getTime(), RedisUtil.toByteArray((Long)order.getId()));
    }

    public void removeWaitForAccept(Long orderId) {
        super.zrem(RedisKeyGenerator.Order.getWaitForAcceptSortSetKey(), new byte[][]{RedisUtil.toByteArray((Long)orderId)});
    }

    public long getWaitForAcceptOrderCount() {
        return super.zcount(RedisKeyGenerator.Order.getWaitForAcceptSortSetKey(), "-inf", "+inf");
    }

    public List<Long> getWaitForAcceptOrderIds(int from, int to) {
        return RedisUtil.bytesSetToLongList(super.zrevrange(RedisKeyGenerator.Order.getWaitForAcceptSortSetKey(), from, to));
    }

    public void addSyncOMSFailedSortSet(Long orderId) {
        super.zadd(RedisKeyGenerator.Order.getSyncOMSFailedSetKey(), System.currentTimeMillis(), RedisUtil.toByteArray((Long)orderId));
    }

    public List<Long> getSyncOMSFailedOrderIds() {
        return RedisUtil.bytesSetToLongList(super.zRange(RedisKeyGenerator.Order.getSyncOMSFailedSetKey(), 0L, -1L));
    }

    public void removeOMSFailedOrderId(Long orderId) {
        this.zrem(RedisKeyGenerator.Order.getSyncOMSFailedSetKey(), new byte[][]{RedisUtil.toByteArray((Long)orderId)});
    }

    public void addCancelOMSFailedOrderId(Long orderId) {
        super.zadd(RedisKeyGenerator.Order.getCancelOMSFailedSetKey(), System.currentTimeMillis(), RedisUtil.toByteArray((Long)orderId));
    }

    public List<Long> getCancelOMSFailedOrderIds() {
        return RedisUtil.bytesSetToLongList(super.zRange(RedisKeyGenerator.Order.getCancelOMSFailedSetKey(), 0L, -1L));
    }

    public void removeCancelOMSFailedOrderId(Long orderId) {
        this.zrem(RedisKeyGenerator.Order.getCancelOMSFailedSetKey(), new byte[][]{RedisUtil.toByteArray((Long)orderId)});
    }

    public Long getOrderIdByNuomiOrderId(long nuomiId) {
        long prefix = nuomiId % 10000L;
        return super.zscoreToLong(RedisKeyGenerator.Order.getNuomiOrderSortSetKey(prefix), RedisUtil.toByteArray((Long)nuomiId));
    }

    public void addNuomiOrderId(long nuomiId, long selfOrderId) {
        long prefix = nuomiId % 10000L;
        super.zadd(RedisKeyGenerator.Order.getNuomiOrderSortSetKey(prefix), selfOrderId, RedisUtil.toByteArray((Long)nuomiId));
    }

    public void addSyncNuomiFailedSortSet(Long orderId) {
        super.zadd(RedisKeyGenerator.Order.getSyncNuomiFailedSetKey(), System.currentTimeMillis(), RedisUtil.toByteArray((Long)orderId));
    }

    public List<Long> getSyncNuomiFailedOrderIds() {
        return RedisUtil.bytesSetToLongList(super.zRange(RedisKeyGenerator.Order.getSyncNuomiFailedSetKey(), 0L, -1L));
    }

    public void removeNuomiFailedOrderId(Long orderId) {
        this.zrem(RedisKeyGenerator.Order.getSyncNuomiFailedSetKey(), new byte[][]{RedisUtil.toByteArray((Long)orderId)});
    }

    public Long getOrderCode(String dateStr) {
        return this.hincrBy(RedisKeyGenerator.Order.getOrderCodeKey(StringUtils.left((String)dateStr, (int)6)), RedisUtil.toByteArray((String)StringUtils.right((String)dateStr, (int)2)), 1L);
    }

    private String removeOrderPrefix(String code) {
        if (StringUtils.startsWithIgnoreCase((String)code, (String)"B2B")) {
            code = StringUtils.removeStartIgnoreCase((String)code, (String)"B2B");
        }
        return code;
    }

    public Long getOrderIdByOrderCode(String code) {
        code = this.removeOrderPrefix(code);
        String dateStr = StringUtils.left((String)code, (int)8);
        return super.zscoreToLong(RedisKeyGenerator.Order.getOrderId2OrderCodeSortSetKey(dateStr), RedisUtil.toByteArray((String)code));
    }

    public void saveOrderIdAndOrderCode(String code, Long orderId) {
        code = this.removeOrderPrefix(code);
        String dateStr = StringUtils.left((String)code, (int)8);
        super.zadd(RedisKeyGenerator.Order.getOrderId2OrderCodeSortSetKey(dateStr), orderId.longValue(), RedisUtil.toByteArray((String)code));
    }

    public OrderStockRo save(OrderStockRo orderStockRo) {
        this.hmset(RoKeyGenerator.getHashKey(orderStockRo.getClass(), (Serializable)((Object)orderStockRo.getOrderCode())), RoConverter.toMap((Object)orderStockRo));
        this.expire(RoKeyGenerator.getHashKey(orderStockRo.getClass(), (Serializable)((Object)orderStockRo.getOrderCode())), 1296000);
        return orderStockRo;
    }

    public OrderStockRo findOne(String orderCode) {
        if (StringUtils.isBlank((String)orderCode)) {
            return null;
        }
        return (OrderStockRo)RoConverter.fromMap(this.hgetAll(RoKeyGenerator.getHashKey(OrderStockRo.class, (Serializable)((Object)orderCode))), OrderStockRo.class);
    }

    public void delete(String orderCode) {
        this.del(RoKeyGenerator.getHashKey(OrderStockRo.class, (Serializable)((Object)orderCode)));
    }

    public Integer incOrderDepotQuantity(String orderCode, String mcuCode, String centerId, int quantity) {
        if (StringUtils.isBlank((String)orderCode) || StringUtils.isBlank((String)mcuCode)) {
            return 0;
        }
        Long value = this.hincrBy(RoKeyGenerator.getHashKey(OrderStockRo.class, (Serializable)((Object)orderCode)), RedisUtil.toByteArray((String)RedisKeyGenerator.Order.getOrderDepotProductStockFieldKey(mcuCode, centerId)), quantity);
        if (value < 0L) {
            this.hset(RoKeyGenerator.getHashKey(OrderStockRo.class, (Serializable)((Object)orderCode)), RedisKeyGenerator.Order.getOrderDepotProductStockFieldKey(mcuCode, centerId), RedisUtil.toBitByteArray((int)0));
        }
        return value.intValue();
    }

    public Integer getOrderDepotQuantity(String orderCode, String mcuCode, String centerId) {
        if (StringUtils.isBlank((String)orderCode) || StringUtils.isBlank((String)mcuCode)) {
            return 0;
        }
        byte[] b = this.hget(RoKeyGenerator.getHashKey(OrderStockRo.class, (Serializable)((Object)orderCode)), RedisKeyGenerator.Order.getOrderDepotProductStockFieldKey(mcuCode, centerId));
        if (ArrayUtils.isNotEmpty((byte[])b) && NumberUtils.isNumber((String)new String(b))) {
            Integer quantity = RedisUtil.byteArrayToInt((byte[])b);
            return ValueUtils.getValue((Integer)quantity) > 0 ? quantity : 0;
        }
        return 0;
    }

    public void updateOrderStockStatus(String orderCode, CommonStatus status) {
        if (StringUtils.isBlank((String)orderCode) || status == null) {
            return;
        }
        this.hset(RoKeyGenerator.getHashKey(OrderStockRo.class, (Serializable)((Object)orderCode)), "status", RedisUtil.toByteArray((String)status.name()));
    }
}

