/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.order;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.order.ShoppingCartItemRo;
import com.depotnearby.common.util.ExternalizationHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;
import redis.clients.jedis.Tuple;

@Repository
public class ShoppingCartRedisDao
extends CommonRedisDao {
    public Integer saveShoppingCartItemRo(Long userId, ShoppingCartItemRo shoppingCartItemRo) {
        if (userId == null || shoppingCartItemRo.getProductId() == null || shoppingCartItemRo.getQuantity() == null || shoppingCartItemRo.getCreateTime() == null) {
            return 0;
        }
        List<ShoppingCartItemRo> shoppingCartItems = this.getShoppingCartItemsByUserId(userId);
        if (CollectionUtils.isNotEmpty(shoppingCartItems)) {
            for (ShoppingCartItemRo ro : shoppingCartItems) {
                if (!Objects.equals(ro.getProductId(), shoppingCartItemRo.getProductId())) continue;
                shoppingCartItemRo.setCreateTime(ro.getCreateTime());
                this.zrem(RedisKeyGenerator.ShoppingCart.getShoppingCartUserIdSortedSetKey(userId), new byte[][]{ExternalizationHelper.serialize(ro)});
                break;
            }
        }
        this.zadd(RedisKeyGenerator.ShoppingCart.getShoppingCartUserIdSortedSetKey(userId), shoppingCartItemRo.getCreateTime().getTime(), ExternalizationHelper.serialize(shoppingCartItemRo));
        return shoppingCartItemRo.getQuantity();
    }

    public List<ShoppingCartItemRo> getShoppingCartItemsByUserId(Long userId) {
        if (userId == null) {
            return Lists.newArrayList();
        }
        TreeSet sortedShoppingCartItems = Sets.newTreeSet();
        Set<Tuple> shoppingCartItemWithScoreTuples = this.zrevrangeWithScore(RedisKeyGenerator.ShoppingCart.getShoppingCartUserIdSortedSetKey(userId), 0L, -1L);
        if (CollectionUtils.isNotEmpty(shoppingCartItemWithScoreTuples)) {
            for (Tuple tuple : shoppingCartItemWithScoreTuples) {
                sortedShoppingCartItems.add((ShoppingCartItemRo)ExternalizationHelper.deserialize(new ShoppingCartItemRo(), tuple.getBinaryElement()));
            }
        }
        return Lists.newArrayList((Iterable)sortedShoppingCartItems);
    }

    public Integer getShoppingCartProductQuantity(Long userId, Long productId) {
        if (userId == null || productId == null) {
            return 0;
        }
        List<ShoppingCartItemRo> shoppingCartItems = this.getShoppingCartItemsByUserId(userId);
        if (CollectionUtils.isEmpty(shoppingCartItems)) {
            return 0;
        }
        for (ShoppingCartItemRo shoppingCartItemRo : shoppingCartItems) {
            if (!Objects.equals(shoppingCartItemRo.getProductId(), productId)) continue;
            return shoppingCartItemRo.getQuantity();
        }
        return 0;
    }

    public void removeShoppingCartItems(Long userId, Collection<Long> productIds) {
        if (userId == null) {
            return;
        }
        if (CollectionUtils.isNotEmpty(productIds)) {
            List<ShoppingCartItemRo> shoppingCartItems = this.getShoppingCartItemsByUserId(userId);
            for (Long productId : productIds) {
                for (ShoppingCartItemRo shoppingCartItemRo : shoppingCartItems) {
                    if (!Objects.equals(shoppingCartItemRo.getProductId(), productId)) continue;
                    this.zrem(RedisKeyGenerator.ShoppingCart.getShoppingCartUserIdSortedSetKey(userId), new byte[][]{ExternalizationHelper.serialize(shoppingCartItemRo)});
                }
            }
        } else {
            this.del(RedisKeyGenerator.ShoppingCart.getShoppingCartUserIdSortedSetKey(userId));
        }
    }

    public void saveWisdomShoppingCartItems(Long userId, List<ShoppingCartItemRo> ros) {
        if (CollectionUtils.isEmpty(ros)) {
            return;
        }
        String key = RedisKeyGenerator.ShoppingCart.getWisdomProductSetKey(userId);
        for (ShoppingCartItemRo ro : ros) {
            byte[] roByte = ExternalizationHelper.serialize(ro);
            this.sadd(key, roByte);
            this.expire(key, 3600000);
        }
    }

    public List<ShoppingCartItemRo> getWisdomShoppingCartItems(Long userId) {
        if (userId == null) {
            return Lists.newArrayList();
        }
        Set<byte[]> wisdomProducts = this.smembers(RedisKeyGenerator.ShoppingCart.getWisdomProductSetKey(userId));
        ArrayList<ShoppingCartItemRo> shoppingCartItems = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(wisdomProducts)) {
            shoppingCartItems = new ArrayList<ShoppingCartItemRo>();
            for (byte[] wisdomProduct : wisdomProducts) {
                shoppingCartItems.add((ShoppingCartItemRo)ExternalizationHelper.deserialize(new ShoppingCartItemRo(), wisdomProduct));
            }
        }
        return shoppingCartItems;
    }
}

