/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.price;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.bean.RoConverter;
import com.depotnearby.common.ro.bean.RoKeyGenerator;
import com.depotnearby.common.ro.price.PriceRo;
import com.depotnearby.common.ro.product.ProductRo;
import com.depotnearby.common.util.RedisUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PriceRedisDao
extends CommonRedisDao {
    public static String getId(String areaNo, String centerId) {
        return String.format("%s_%s", areaNo, centerId);
    }

    public PriceRo save(PriceRo priceRo) {
        priceRo.setId(PriceRedisDao.getId(priceRo.getAreaNo(), priceRo.getCenterId()));
        this.hmset(RoKeyGenerator.getHashKey(priceRo.getClass(), (Serializable)((Object)priceRo.getId())), RoConverter.toMap((Object)priceRo));
        this.zadd(RoKeyGenerator.getIdSortedSetKey(priceRo.getClass()), System.currentTimeMillis(), RedisUtil.toByteArray((String)priceRo.getId()));
        return priceRo;
    }

    public void save(List<PriceRo> ros) {
        if (CollectionUtils.isEmpty(ros)) {
            return;
        }
        HashMap idToRo = Maps.newHashMap();
        ArrayList ids = Lists.newArrayList();
        ArrayList keys = Lists.newArrayList();
        for (PriceRo ro : ros) {
            ro.setId(PriceRedisDao.getId(ro.getAreaNo(), ro.getCenterId()));
            idToRo.put(RoKeyGenerator.getHashKey(PriceRo.class, (Serializable)((Object)ro.getId())).getBytes(), RoConverter.toMap((Object)ro));
            ids.add(ro.getId());
        }
        super.pipeHmset(idToRo);
        super.pipeZadd(RoKeyGenerator.getIdSortedSetKey(PriceRo.class), System.currentTimeMillis(), ids);
    }

    public PriceRo findOne(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (PriceRo)RoConverter.fromMap(this.hgetAll(RoKeyGenerator.getHashKey(PriceRo.class, (Serializable)((Object)id))), PriceRo.class);
    }

    public PriceRo findByAreaNoAndCenterId(String areaNo, String centerId) {
        if (StringUtils.isBlank((CharSequence)areaNo) || StringUtils.isBlank((CharSequence)centerId)) {
            return null;
        }
        return this.findOne(PriceRedisDao.getId(areaNo, centerId));
    }

    public Map<Long, PriceRo> findByAreaNoAndProducts(String areaNo, Collection<ProductRo> products) {
        HashMap priceRoMap = Maps.newHashMap();
        if (StringUtils.isBlank((CharSequence)areaNo) || CollectionUtils.isEmpty(products)) {
            return priceRoMap;
        }
        HashMap<String, ProductRo> centIdToProduct = new HashMap<String, ProductRo>(products.size());
        for (ProductRo productRo : products) {
            centIdToProduct.put(productRo.getCenterId(), productRo);
        }
        ArrayList idKeys = Lists.newArrayList();
        for (String productCenterId : centIdToProduct.keySet()) {
            idKeys.add(RoKeyGenerator.getHashKey(PriceRo.class, (Serializable)((Object)PriceRedisDao.getId(areaNo, productCenterId))));
        }
        List<PriceRo> list = this.findByIds(idKeys);
        for (PriceRo priceRo : list) {
            priceRoMap.put(((ProductRo)((Object)centIdToProduct.get(priceRo.getCenterId()))).getId(), priceRo);
        }
        return priceRoMap;
    }

    public void delete(String id) {
        this.del(RoKeyGenerator.getHashKey(PriceRo.class, (Serializable)((Object)id)));
        this.zrem(RoKeyGenerator.getIdSortedSetKey(PriceRo.class), id);
    }

    public void delete(String areaNo, String centerId) {
        if (StringUtils.isBlank((CharSequence)areaNo) || StringUtils.isBlank((CharSequence)centerId)) {
            return;
        }
        String id = PriceRedisDao.getId(areaNo, centerId);
        this.del(RoKeyGenerator.getHashKey(PriceRo.class, (Serializable)((Object)id)));
        this.zrem(RoKeyGenerator.getIdSortedSetKey(PriceRo.class), id);
    }

    public List<PriceRo> findByIds(Collection<String> ids) {
        ArrayList priceRos = Lists.newArrayList();
        List roMaps = this.pipeHgetall(ids);
        for (Object roMap : roMaps) {
            PriceRo priceRo = (PriceRo)RoConverter.fromMap((Map)((Map)roMap), PriceRo.class);
            if (priceRo == null || !StringUtils.isNotBlank((CharSequence)priceRo.getId())) continue;
            priceRos.add(priceRo);
        }
        return priceRos;
    }
}

