/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.price;

import cn.com.bizunited.cp.common.utils.ModelMapperUtils;
import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.po.price.RedPricePo;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.price.RedPriceRo;
import java.util.List;
import java.util.Map;
import org.codelogger.utils.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class RedPriceRedisDao
extends CommonRedisDao {
    public void save(List<RedPricePo> pos) {
        if (CollectionUtils.isNotEmpty(pos)) {
            return;
        }
        List roList = ModelMapperUtils.toParseList(pos, RedPriceRo.class);
        for (RedPriceRo ro : roList) {
            this.hmset(RedisKeyGenerator.RedPriceRedisKey.getRedPriceAreaProcduceKey(ro.getAreaCode(), ro.getProductCode()), ro.toMap());
        }
    }

    public void save(RedPricePo po) {
        if (po == null) {
            return;
        }
        RedPriceRo ro = (RedPriceRo)((Object)ModelMapperUtils.toParse((Object)po, RedPriceRo.class));
        this.hmset(RedisKeyGenerator.RedPriceRedisKey.getRedPriceAreaProcduceKey(ro.getAreaCode(), ro.getProductCode()), ro.toMap());
    }

    public void delete(String areaCode, String productCode) {
        this.del(RedisKeyGenerator.RedPriceRedisKey.getRedPriceAreaProcduceKey(areaCode, productCode));
    }

    public RedPriceRo getRedPriceRo(String areaCode, String productCode) {
        RedPriceRo ro = new RedPriceRo();
        Map<byte[], byte[]> map = this.hgetAll(RedisKeyGenerator.RedPriceRedisKey.getRedPriceAreaProcduceKey(areaCode, productCode));
        if (map != null) {
            ro.fromMap(map);
        }
        return ro;
    }
}

