/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.product;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.product.CategoryRo;
import com.depotnearby.common.util.RedisUtil;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Component;

@Component
public class CategoryRedisDao
extends CommonRedisDao {
    public void save(CategoryRo ro) {
        super.hmset(RedisKeyGenerator.Category.getHashKey(ro.getId()), ro.toMap());
    }

    public CategoryRo get(Integer id) {
        if (id == null) {
            return null;
        }
        Map<byte[], byte[]> map = this.hgetAll(RedisKeyGenerator.Category.getHashKey(id));
        if (MapUtils.isNotEmpty(map)) {
            CategoryRo ro = new CategoryRo();
            ro.fromMap(map);
            return ro;
        }
        return null;
    }

    public String getFilterJson(Integer categoryId) {
        byte[] b = super.hget(RedisKeyGenerator.Category.getHashKey(categoryId), "filterJson");
        if (b != null) {
            return RedisUtil.byteArrayToStr((byte[])b);
        }
        return null;
    }
}

