/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.product;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.bean.RoConverter;
import com.depotnearby.common.ro.product.DepotProductRo;
import com.depotnearby.common.ro.product.ProductRo;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.codelogger.utils.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class DepotProductRedisDao
extends CommonRedisDao {
    public void save(DepotProductRo ro) {
        this.hmset(RedisKeyGenerator.DepotProduct.getDepotProductHashKey(ro.getProductId(), ro.getDepotId()), ro.toMap());
    }

    public void delete(Long productId, String depotId) {
        this.del(RedisKeyGenerator.DepotProduct.getDepotProductHashKey(productId, depotId));
    }

    public DepotProductRo get(Long productId, String depotId) {
        if (productId == null || StringUtils.isBlank((CharSequence)depotId)) {
            return null;
        }
        String depotProductHashKey = RedisKeyGenerator.DepotProduct.getDepotProductHashKey(productId, depotId);
        return this.loadFromCacheOrCacheLoader("get", new CacheLoader<String, DepotProductRo>(){

            public DepotProductRo load(String key) throws Exception {
                Map map = DepotProductRedisDao.this.hgetAll(key);
                if (MapUtils.isNotEmpty((Map)map)) {
                    DepotProductRo ro = new DepotProductRo();
                    ro.fromMap(map);
                    return ro;
                }
                return null;
            }
        }, depotProductHashKey, TimeUnit.SECONDS, 5L);
    }

    public void save(List<DepotProductRo> depotProductRos) {
        if (CollectionUtils.isEmpty(depotProductRos)) {
            return;
        }
        LinkedHashMap roMaps = Maps.newLinkedHashMap();
        for (DepotProductRo ro : depotProductRos) {
            roMaps.put(RedisKeyGenerator.DepotProduct.getDepotProductHashKey(ro.getProductId(), ro.getDepotId()).getBytes(), ro.toMap());
        }
        this.pipeHmset(roMaps);
    }

    public List<DepotProductRo> getDepotProductRosByDepotIdAndProductIds(String depotId, Map<Long, ProductRo> productRoMap) {
        if (StringUtils.isBlank((CharSequence)depotId) || MapUtils.isEmpty(productRoMap)) {
            return Lists.newArrayList();
        }
        ArrayList<DepotProductRo> depotProductRoMap = new ArrayList<DepotProductRo>(productRoMap.size());
        ArrayList<String> keys = new ArrayList<String>(productRoMap.size());
        for (Long productId : productRoMap.keySet()) {
            keys.add(RedisKeyGenerator.DepotProduct.getDepotProductHashKey(productId, depotId));
        }
        List roMaps = super.pipeHgetall(keys);
        for (Object roMap : roMaps) {
            DepotProductRo depotProductRo = (DepotProductRo)((Object)RoConverter.fromMap((Map)((Map)roMap), DepotProductRo.class));
            if (depotProductRo == null) continue;
            depotProductRoMap.add(depotProductRo);
        }
        return depotProductRoMap;
    }
}

