/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.product;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.util.RedisUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.codelogger.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class IncreaseRedisDao
extends CommonRedisDao {
    private static final Logger logger = LoggerFactory.getLogger(IncreaseRedisDao.class);

    public void addProduct(Long productId) {
        logger.debug("add increase product {}", (Object)productId);
        super.zadd(RedisKeyGenerator.Increase.getProductSortSetKey(), System.currentTimeMillis(), RedisUtil.toByteArray((Long)productId));
    }

    public void clearIncBefore24Hour() {
        super.zremrangeByScore(RedisKeyGenerator.Increase.getProductSortSetKey(), "-inf", String.valueOf(System.currentTimeMillis() - 86400000L));
        super.zremrangeByScore(RedisKeyGenerator.Increase.getDepotProductSortSetKey(), "-inf", String.valueOf(System.currentTimeMillis() - 86400000L));
    }

    public Set<byte[]> getProductIds(long ts) {
        return super.zangeByScore(RedisKeyGenerator.Increase.getProductSortSetKey(), String.valueOf(ts), "+inf");
    }

    public void addDepotProductId(Long id) {
        logger.debug("add increase depot product {}", (Object)id);
        super.zadd(RedisKeyGenerator.Increase.getDepotProductSortSetKey(), System.currentTimeMillis(), RedisUtil.toByteArray((Long)id));
    }

    public void addDepotProductIds(Collection<Long> ids) {
        logger.debug("add increase depot product {}", ids);
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ArrayList dataList = Lists.newArrayList();
        for (Long id : ids) {
            dataList.add(id.toString());
        }
        this.pipeZadd(RedisKeyGenerator.Increase.getDepotProductSortSetKey(), System.currentTimeMillis(), dataList);
    }

    public Set<byte[]> getDepotProductIds(long ts) {
        return super.zangeByScore(RedisKeyGenerator.Increase.getDepotProductSortSetKey(), String.valueOf(ts), "+inf");
    }

    public void addProductLockSell(Long id) {
        logger.debug("add increase product id of lock sell {}", (Object)id);
        super.zadd(RedisKeyGenerator.Increase.getProductLockSellSortSetKey(), System.currentTimeMillis(), RedisUtil.toByteArray((Long)id));
    }

    public List<Long> getProductIdsOfLockSell(long ts) {
        Set<byte[]> productIds = super.zangeByScore(RedisKeyGenerator.Increase.getProductLockSellSortSetKey(), String.valueOf(ts), "+inf");
        return RedisUtil.bytesSetToLongList(productIds);
    }
}

