/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.product;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.bean.RoConverter;
import com.depotnearby.common.ro.product.ProductCompanyRo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.codelogger.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProductCompanyRedisDao
extends CommonRedisDao {
    private static final Logger logger = LoggerFactory.getLogger(ProductCompanyRedisDao.class);

    public void save(ProductCompanyRo ro) {
        this.hmset(RedisKeyGenerator.ProductCompany.getProductCompanyHashKey(ro.getProductId(), ro.getCompanyId()), ro.toMap());
    }

    public void delete(Long productId, Long companyId) {
        this.del(RedisKeyGenerator.ProductCompany.getProductCompanyHashKey(productId, companyId));
    }

    public ProductCompanyRo get(Long productId, Long companyId) {
        if (productId == null || companyId == null) {
            return null;
        }
        Map<byte[], byte[]> map = this.hgetAll(RedisKeyGenerator.ProductCompany.getProductCompanyHashKey(productId, companyId));
        if (MapUtils.isNotEmpty(map)) {
            ProductCompanyRo ro = new ProductCompanyRo();
            ro.fromMap(map);
            return ro;
        }
        return null;
    }

    public Map<String, ProductCompanyRo> getAllByProductIdAndCompanyId(List<Long> productIds, Long companyId) {
        HashMap<String, ProductCompanyRo> productCompanyRoMap = new HashMap<String, ProductCompanyRo>();
        if (CollectionUtils.isNotEmpty(productIds) && companyId != null) {
            ArrayList<String> keys = new ArrayList<String>(productIds.size());
            for (Long productId : productIds) {
                keys.add(RedisKeyGenerator.ProductCompany.getProductCompanyHashKey(productId, companyId));
            }
            List roMaps = super.pipeHgetall(keys);
            for (Object roMap : roMaps) {
                ProductCompanyRo productCompanyRo = (ProductCompanyRo)((Object)RoConverter.fromMap((Map)((Map)roMap), ProductCompanyRo.class));
                if (productCompanyRo == null) continue;
                productCompanyRoMap.put(RedisKeyGenerator.ProductCompany.getProductCompanyHashKey(productCompanyRo.getProductId(), productCompanyRo.getCompanyId()), productCompanyRo);
            }
        }
        return productCompanyRoMap;
    }
}

