/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.product;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.bean.RoConverter;
import com.depotnearby.common.ro.lock.LockSellProductRo;
import com.depotnearby.common.ro.product.ProductRo;
import com.depotnearby.common.util.RedisUtil;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.codelogger.utils.CollectionUtils;
import org.codelogger.utils.JudgeUtils;
import org.springframework.stereotype.Component;

@Component
public class ProductRedisDao
extends CommonRedisDao {
    public void settingLastSyncTime(String key, Long currentTime) {
        super.set(key, String.valueOf(currentTime));
    }

    public String gettingLastSyncTime(String key) {
        return super.getString(key);
    }

    public void save(ProductRo ro) {
        this.hmset(RedisKeyGenerator.Product.getProductHashKey(ro.getId()), ro.toMap());
    }

    public void delete(Long id) {
        this.del(RedisKeyGenerator.Product.getProductHashKey(id));
    }

    public ProductRo get(Long productId) {
        if (productId == null) {
            return null;
        }
        return this.loadFromCacheOrCacheLoader("get", new CacheLoader<String, ProductRo>(){

            public ProductRo load(String key) throws Exception {
                Map map = ProductRedisDao.this.hgetAll(key);
                if (MapUtils.isNotEmpty((Map)map)) {
                    ProductRo ro = new ProductRo();
                    ro.fromMap(map);
                    return ro;
                }
                return null;
            }
        }, RedisKeyGenerator.Product.getProductHashKey(productId), TimeUnit.SECONDS, 5L);
    }

    public void incSalesVolume(Long id, int quantity) {
        super.hincrBy(RedisKeyGenerator.Product.getProductHashKey(id), "salesVolume".getBytes(), quantity);
    }

    public void incPageView(Long id, int pageView) {
        super.hincrBy(RedisKeyGenerator.Product.getProductHashKey(id), "pageView".getBytes(), pageView);
    }

    public List<Long> getDefaultRecommedProductIds() {
        return RedisUtil.stringSetToLongList(this.zrangeByScore(RedisKeyGenerator.Product.getDefaultRecommendProductSortSetKey(), "-inf", "+inf"));
    }

    public void reduceShowQuantity(Long productId, int showQuantity, boolean isReduce) {
        int reduce = isReduce ? -1 : 1;
        this.hincrBy(RedisKeyGenerator.Product.getProductHashKey(productId), RedisUtil.toByteArray((String)RedisKeyGenerator.Product.getStockFieldName()), reduce * showQuantity);
    }

    public Integer getShowQuantity(Long id) {
        byte[] b = this.hget(RedisKeyGenerator.Product.getProductHashKey(id), RedisKeyGenerator.Product.getVitualStockFieldName());
        if (b != null) {
            return RedisUtil.byteArrayToInt((byte[])b);
        }
        return null;
    }

    public void reduceVirtualQuantity(Long productId, int quantity, boolean isReduce) {
        int reduce = isReduce ? -1 : 1;
        this.hincrBy(RedisKeyGenerator.Product.getProductHashKey(productId), RedisUtil.toByteArray((String)RedisKeyGenerator.Product.getVitualStockFieldName()), reduce * quantity);
    }

    public Integer getVirtualQuantity(Long id) {
        byte[] b = this.hget(RedisKeyGenerator.Product.getProductHashKey(id), RedisKeyGenerator.Product.getVitualStockFieldName());
        if (b != null) {
            return RedisUtil.byteArrayToInt((byte[])b);
        }
        return null;
    }

    public ProductRo getProductRoByCenterId(String centerId) {
        Long productId = RedisUtil.byteArrayToLong((byte[])this.get(RedisKeyGenerator.Product.getCenterIdToProductIdKey(centerId)));
        return productId != null ? this.get(productId) : null;
    }

    public void mapCenterIdToProductId(String centerId, Long productId) {
        this.set(RedisKeyGenerator.Product.getCenterIdToProductIdKey(centerId), RedisUtil.toByteArray((Long)productId));
    }

    public void saveLockSell(List<Long> companyIds, Long productId, Timestamp sellStartTime, Timestamp sellEndTime) {
        if (null == productId || null == sellStartTime || null == sellEndTime) {
            return;
        }
        this.del(RedisKeyGenerator.ProductCompany.getCompanyProductLockSellSetKey(productId));
        for (Long companyId : companyIds) {
            this.sadd(RedisKeyGenerator.ProductCompany.getCompanyProductLockSellSetKey(productId), String.valueOf(companyId).getBytes());
        }
        if (CollectionUtils.isEmpty(companyIds)) {
            this.srem(RedisKeyGenerator.ProductCompany.getProductLockSellCompanySetKey(), String.valueOf(productId).getBytes());
            this.del(RedisKeyGenerator.ProductCompany.getProductLockSellRoCompanySetKey(productId));
        } else {
            this.sadd(RedisKeyGenerator.ProductCompany.getProductLockSellCompanySetKey(), String.valueOf(productId).getBytes());
            this.hmset(RedisKeyGenerator.ProductCompany.getProductLockSellRoCompanySetKey(productId), new LockSellProductRo(productId, sellStartTime, sellEndTime).toMap());
        }
    }

    public List<Long> getLockSell(Long productId) {
        if (null == productId) {
            return Lists.newArrayList();
        }
        Set<byte[]> lockCompanyIds = this.smembers(RedisKeyGenerator.ProductCompany.getCompanyProductLockSellSetKey(productId));
        if (CollectionUtils.isNotEmpty(lockCompanyIds)) {
            ArrayList companyIds = Lists.newArrayList();
            for (byte[] companyId : lockCompanyIds) {
                companyIds.add(Long.parseLong(new String(companyId)));
            }
            return companyIds;
        }
        return Lists.newArrayList();
    }

    public LockSellProductRo findLockSellProductRoByProduct(Long productId) {
        LockSellProductRo ro = new LockSellProductRo();
        Map<byte[], byte[]> map = this.hgetAll(RedisKeyGenerator.ProductCompany.getProductLockSellRoCompanySetKey(productId));
        if (MapUtils.isNotEmpty(map)) {
            ro.fromMap(map);
            return ro;
        }
        return null;
    }

    public Boolean isLockSell(Long productId, Long companyId) {
        if (JudgeUtils.allIsNull((Object)productId, (Object[])new Object[]{companyId})) {
            return false;
        }
        LockSellProductRo lockSellProductRo = this.findLockSellProductRoByProduct(productId);
        if (null != lockSellProductRo) {
            Long lockStartTime = lockSellProductRo.getLockStartTime().getTime();
            Long lockEndTime = lockSellProductRo.getLockEndTime().getTime();
            Long nowTime = System.currentTimeMillis();
            if (nowTime > lockEndTime || nowTime < lockStartTime) {
                this.logger.debug("\u9501\u5b9a\u9500\u552e\u5546\u54c1\u6ca1\u5728\u6709\u6548\u671f\uff0c\u5f53\u524d\u65f6\u95f4: {}, \u5f00\u59cb\u65f6\u95f4: {}, \u7ed3\u675f\u65f6\u95f4: {}", new Object[]{nowTime, lockStartTime, lockEndTime});
                return false;
            }
        } else {
            return false;
        }
        return this.sismember(RedisKeyGenerator.ProductCompany.getCompanyProductLockSellSetKey(productId), RedisUtil.toByteArray((Long)companyId));
    }

    public List<LockSellProductRo> getLockSellProductIdAll() {
        Set<byte[]> productIdsBytes = this.smembers(RedisKeyGenerator.ProductCompany.getProductLockSellCompanySetKey());
        ArrayList productIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(productIdsBytes)) {
            for (byte[] productId : productIdsBytes) {
                productIds.add(Long.parseLong(new String(productId)));
            }
        }
        ArrayList lockSellProductRos = Lists.newArrayList();
        for (Long productId : productIds) {
            LockSellProductRo lockSellProductRo = this.findLockSellProductRoByProduct(productId);
            if (null == lockSellProductRo) continue;
            lockSellProductRos.add(lockSellProductRo);
        }
        return lockSellProductRos;
    }

    public Map<Long, ProductRo> getProductsByIds(List<Long> productIds) {
        HashMap<Long, ProductRo> productRoMap = new HashMap<Long, ProductRo>();
        if (CollectionUtils.isNotEmpty(productIds)) {
            ArrayList<String> productIdsOfStr = new ArrayList<String>(productIds.size());
            for (Long productId : productIds) {
                if (productId == null) continue;
                String tmpProductId = RedisKeyGenerator.Product.getProductHashKey(productId);
                productIdsOfStr.add(tmpProductId);
            }
            List roMaps = super.pipeHgetall(productIdsOfStr);
            for (Object roMap : roMaps) {
                ProductRo productRo = (ProductRo)((Object)RoConverter.fromMap((Map)((Map)roMap), ProductRo.class));
                if (productRo == null) continue;
                productRoMap.put(productRo.getId(), productRo);
            }
        }
        return productRoMap;
    }
}

