/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.product;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.model.IStatus;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.product.SaleAreaRo;
import com.depotnearby.common.util.RedisUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.codelogger.utils.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class SaleAreaRedisDao
extends CommonRedisDao {
    public void save(SaleAreaRo ro) {
        this.hmset(RedisKeyGenerator.Product.getAreaSaleHashKey(ro.getId()), ro.toMap());
        this.changeStatus(ro.getId(), ro.getStatus());
    }

    public void changeStatus(Integer saleAreaId, Integer status) {
        long currentTimeMillis = System.currentTimeMillis();
        if (Objects.equals(status, IStatus.STATUS_NORMAL)) {
            this.zadd(RedisKeyGenerator.Product.getAreaSaleOfStatusNormalSetKey(), currentTimeMillis, RedisUtil.toByteArray((Integer)saleAreaId));
        } else {
            this.zrem(RedisKeyGenerator.Product.getAreaSaleOfStatusNormalSetKey(), new byte[][]{RedisUtil.toByteArray((Integer)saleAreaId)});
        }
    }

    public List<SaleAreaRo> findNormal() {
        Set<byte[]> idBytesSet = this.zRange(RedisKeyGenerator.Product.getAreaSaleOfStatusNormalSetKey(), 0L, -1L);
        ArrayList saleAreaRo = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(idBytesSet)) {
            for (byte[] idBytes : idBytesSet) {
                saleAreaRo.add(this.findOne(RedisUtil.byteArrayToInt((byte[])idBytes)));
            }
        }
        return saleAreaRo;
    }

    public SaleAreaRo findOne(Integer areaId) {
        String userInfoKey = RedisKeyGenerator.Product.getAreaSaleHashKey(areaId);
        Map<byte[], byte[]> map = this.hgetAll(userInfoKey);
        if (MapUtils.isNotEmpty(map)) {
            SaleAreaRo shopRo = new SaleAreaRo();
            shopRo.fromMap(map);
            return shopRo;
        }
        return null;
    }
}

