/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.promotion;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.bean.RoConverter;
import com.depotnearby.common.ro.bean.RoKeyGenerator;
import com.depotnearby.common.ro.promotion.SalePromotionRo;
import com.depotnearby.common.util.RedisUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.codelogger.utils.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class SalePromotionRedisDao
extends CommonRedisDao {
    public void save(SalePromotionRo ro) {
        super.hmset(RoKeyGenerator.getHashKey(SalePromotionRo.class, (Serializable)ro.getId()), ro.toMap());
        this.zadd(RoKeyGenerator.getIdSortedSetKey(((Object)((Object)ro)).getClass()), System.currentTimeMillis(), RedisUtil.toByteArray((Long)ro.getId()));
    }

    public SalePromotionRo get(Long salePromotionId) {
        if (salePromotionId == null) {
            return null;
        }
        Map<byte[], byte[]> map = this.hgetAll(RoKeyGenerator.getHashKey(SalePromotionRo.class, (Serializable)salePromotionId));
        if (MapUtils.isNotEmpty(map)) {
            SalePromotionRo ro = new SalePromotionRo();
            ro.fromMap(map);
            return ro;
        }
        return null;
    }

    public List<SalePromotionRo> findAll(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        ArrayList keys = Lists.newArrayList();
        for (Long id : ids) {
            keys.add(RoKeyGenerator.getHashKey(SalePromotionRo.class, (Serializable)id));
        }
        List roMaps = this.pipeHgetall(keys);
        ArrayList salePromotionRos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)roMaps)) {
            for (Object roMap : roMaps) {
                salePromotionRos.add(RoConverter.fromMap((Map)((Map)roMap), SalePromotionRo.class));
            }
        }
        return salePromotionRos;
    }

    public void delete(Long salePromotionId) {
        this.logger.debug("delete SalePromotionRo {}", (Object)RoKeyGenerator.getHashKey(SalePromotionRo.class, (Serializable)salePromotionId));
        this.del(RoKeyGenerator.getHashKey(SalePromotionRo.class, (Serializable)salePromotionId));
    }

    public List<SalePromotionRo> getAll() {
        Set<byte[]> idKeys = this.zRange(RoKeyGenerator.getIdSortedSetKey(SalePromotionRo.class), 0L, -1L);
        List ids = RedisUtil.bytesSetToLongList(idKeys);
        return this.findAll(ids);
    }

    public void saveSalePromotionTargetTypeAll(Long salePromotionId) {
        super.sadd(RedisKeyGenerator.SalePromotion.getSalePromotionTargetTypeAllSetKey(), String.valueOf(salePromotionId).getBytes());
    }

    public List<Long> getSalePromotionTargetTypeAll() {
        Set<byte[]> bytes = super.smembers(RedisKeyGenerator.SalePromotion.getSalePromotionTargetTypeAllSetKey());
        List strings = RedisUtil.bytesSetToStringList(bytes);
        return RedisUtil.strListToLongList((List)strings);
    }

    public void deleteSalePrmotionTargetTypeAll(Long salePromotionId) {
        this.logger.debug("deleteSalePrmotionTargetTypeAll {} salePromotionId is {}", (Object)RedisKeyGenerator.SalePromotion.getSalePromotionTargetTypeAllSetKey(), (Object)salePromotionId);
        super.srem(RedisKeyGenerator.SalePromotion.getSalePromotionTargetTypeAllSetKey(), String.valueOf(salePromotionId).getBytes());
    }

    public void saveSalePromotionTargetTypeCategory(Long salePromotionId) {
        super.sadd(RedisKeyGenerator.SalePromotion.getSalePromotionTargetTypeCategorySetKey(), String.valueOf(salePromotionId).getBytes());
    }

    public List<Long> getSalePromotionTargetTypeCategory() {
        Set<byte[]> bytes = super.smembers(RedisKeyGenerator.SalePromotion.getSalePromotionTargetTypeCategorySetKey());
        return RedisUtil.strListToLongList((List)RedisUtil.bytesSetToStringList(bytes));
    }

    public void deleteSalePromotionTargetTypeCategory(Long salePromotionId) {
        this.logger.debug("deleteSalePromotionTargetTypeCategory {} salePromotionId is {}", (Object)RedisKeyGenerator.SalePromotion.getSalePromotionTargetTypeCategorySetKey(), (Object)salePromotionId);
        super.srem(RedisKeyGenerator.SalePromotion.getSalePromotionTargetTypeCategorySetKey(), String.valueOf(salePromotionId).getBytes());
    }

    public void saveProductToSalePromotionList(Long productId, Long salePromotionId) {
        super.sadd(RedisKeyGenerator.ProductToSalePromotionList.getProductToSalePromotionListSetKey(productId), String.valueOf(salePromotionId).getBytes());
    }

    public List<Long> getProductToSalePromotionList(Long productId) {
        Set<byte[]> set = super.smembers(RedisKeyGenerator.ProductToSalePromotionList.getProductToSalePromotionListSetKey(productId));
        return RedisUtil.strListToLongList((List)RedisUtil.bytesSetToStringList(set));
    }

    public void deleteSalePromotion(Long productId, Long salePromotionId) {
        this.logger.debug("deleteSalePromotion {}", (Object)RedisKeyGenerator.ProductToSalePromotionList.getProductToSalePromotionListSetKey(productId));
        super.srem(RedisKeyGenerator.ProductToSalePromotionList.getProductToSalePromotionListSetKey(productId), String.valueOf(salePromotionId).getBytes());
    }

    public void saveStockQuantity(Long salePromotionId, Long productId, Integer salePromotionStockQuantity) {
        for (int i = 0; i < salePromotionStockQuantity; ++i) {
            super.lpush(RedisKeyGenerator.SalePromotion.getSalePromotionAndProductToStockQuantityListKey(salePromotionId, productId), new byte[][]{String.valueOf(productId).getBytes()});
        }
    }

    public Integer reduceStockQuantity(Long salePromotionId, Long productId, Integer reduceQuantity) {
        byte[] bytes;
        Integer tmpQuantity = 0;
        for (int i = 1; i <= reduceQuantity && (bytes = super.lpop(RedisKeyGenerator.SalePromotion.getSalePromotionAndProductToStockQuantityListKey(salePromotionId, productId))) != null; ++i) {
            tmpQuantity = i;
        }
        return tmpQuantity;
    }

    public Integer getStockQuantity(Long salePromotionId, Long productId) {
        int stockquantity = new Long(super.llen(RedisKeyGenerator.SalePromotion.getSalePromotionAndProductToStockQuantityListKey(salePromotionId, productId))).intValue();
        return stockquantity;
    }
}

