/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.search;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.search.SearchLogRo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class SearchRedisDao
extends CommonRedisDao {
    protected static final Logger logger = LoggerFactory.getLogger(SearchRedisDao.class);

    public String getStringValue(String key) {
        byte[] b = super.hget(RedisKeyGenerator.Search.getConfigHashKey(), key);
        if (b != null) {
            return new String(b);
        }
        return null;
    }

    public void setStringValue(String key, String value) {
        super.hset(RedisKeyGenerator.Search.getConfigHashKey(), key, value.getBytes());
    }

    public byte[] getValue(String key) {
        return super.hget(RedisKeyGenerator.Search.getConfigHashKey(), key);
    }

    public void setValue(String key, byte[] value) {
        super.hset(RedisKeyGenerator.Search.getConfigHashKey(), key, value);
    }

    public void saveSearchKeyword(SearchLogRo ro) {
        this.rpush(RedisKeyGenerator.Search.getSearchLogQueueKey(), ro.toByte());
    }

    public List<SearchLogRo> dumpSearchLog(int size) {
        byte[] content;
        ArrayList<SearchLogRo> result = new ArrayList<SearchLogRo>(size);
        for (int i = 0; i < size && (content = this.lpop(RedisKeyGenerator.Search.getSearchLogQueueKey())) != null; ++i) {
            SearchLogRo ro = new SearchLogRo();
            try {
                ro.fromByte(content);
                result.add(ro);
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return result;
    }

    public boolean getLockToBuildIndexByType(String indexTypeName, int lockTimeInMis) {
        String key = RedisKeyGenerator.Search.getLockByTypeNameKey(indexTypeName);
        boolean result = this.setnx(key, "".getBytes());
        if (result) {
            this.expire(key, lockTimeInMis);
        }
        return result;
    }
}

