/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.shop;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.shop.LogisticsCompanyRo;
import com.depotnearby.common.shop.ShopTypeStatus;
import com.depotnearby.common.util.RedisUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.codelogger.utils.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class LogisticsCompanyRedisDao
extends CommonRedisDao {
    public List<LogisticsCompanyRo> findAll() {
        Set<byte[]> idBytesSet = this.zRange(RedisKeyGenerator.Shop.getAllLogisticsCompanySortSetKey(), 0L, -1L);
        ArrayList logisticsCompanyRos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(idBytesSet)) {
            for (byte[] idBytes : idBytesSet) {
                logisticsCompanyRos.add(this.findOne(RedisUtil.byteArrayToLong((byte[])idBytes)));
            }
        }
        return logisticsCompanyRos;
    }

    public List<LogisticsCompanyRo> findAll(ShopTypeStatus shopTypeStatus) {
        Set<byte[]> idBytesSet = this.zRange(RedisKeyGenerator.Shop.getAllLogisticsOfStatusSortSetKey(shopTypeStatus), 0L, -1L);
        ArrayList logisticsCompanyRos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(idBytesSet)) {
            for (byte[] idBytes : idBytesSet) {
                logisticsCompanyRos.add(this.findOne(RedisUtil.byteArrayToLong((byte[])idBytes)));
            }
        }
        return logisticsCompanyRos;
    }

    public void save(LogisticsCompanyRo logisticsCompanyRo) {
        this.hmset(RedisKeyGenerator.Shop.getLogisticsCompanyHashKey(logisticsCompanyRo.getId()), logisticsCompanyRo.toMap());
        long currentTimeMillis = System.currentTimeMillis();
        this.zadd(RedisKeyGenerator.Shop.getAllLogisticsCompanySortSetKey(), currentTimeMillis, RedisUtil.toByteArray((Long)logisticsCompanyRo.getId()));
        if (Objects.equals(logisticsCompanyRo.getStatus(), ShopTypeStatus.NORMAL.getValue())) {
            this.zadd(RedisKeyGenerator.Shop.getAllShopTypeOfStatusSortSetKey(ShopTypeStatus.NORMAL), currentTimeMillis, RedisUtil.toByteArray((Long)logisticsCompanyRo.getId()));
        } else {
            this.zrem(RedisKeyGenerator.Shop.getAllLogisticsOfStatusSortSetKey(ShopTypeStatus.NORMAL), new byte[][]{RedisUtil.toByteArray((Long)logisticsCompanyRo.getId())});
        }
    }

    public void update(LogisticsCompanyRo logisticsCompanyRo) {
        this.hmset(RedisKeyGenerator.Shop.getShopTypeHashKey(logisticsCompanyRo.getId()), logisticsCompanyRo);
    }

    public LogisticsCompanyRo findOne(Long logisticsCompanyId) {
        String userInfoKey = RedisKeyGenerator.Shop.getLogisticsCompanyHashKey(logisticsCompanyId);
        Map<byte[], byte[]> map = this.hgetAll(userInfoKey);
        if (MapUtils.isNotEmpty(map)) {
            LogisticsCompanyRo userInfo = new LogisticsCompanyRo();
            userInfo.fromMap(map);
            return userInfo;
        }
        return null;
    }

    public void delete(Long logisticsCompanyId) {
        this.del(RedisKeyGenerator.Shop.getShopTypeHashKey(logisticsCompanyId));
        this.zrem(RedisKeyGenerator.Shop.getAllShopTypeSortSetKey(), new byte[][]{RedisUtil.toByteArray((Long)logisticsCompanyId)});
        this.zrem(RedisKeyGenerator.Shop.getAllLogisticsOfStatusSortSetKey(ShopTypeStatus.NORMAL), new byte[][]{RedisUtil.toByteArray((Long)logisticsCompanyId)});
    }
}

