/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.shop;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.shop.ShopRo;
import com.depotnearby.common.util.RedisUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ShopRedisDao
extends CommonRedisDao {
    public void save(ShopRo shopRo) {
        this.hmset(RedisKeyGenerator.Shop.getShopHashKey(shopRo.getId()), shopRo.toMap());
        if (shopRo.getChannel() != null && shopRo.getChannelUserId() != null) {
            String channelAndChannelUserIdToShopIdHashKey = RedisKeyGenerator.Shop.getChannelAndChannelUserIdToShopIdHashKey(shopRo.getChannel(), shopRo.getChannelUserId());
            this.set(channelAndChannelUserIdToShopIdHashKey, RedisUtil.toByteArray((Long)shopRo.getId()));
        }
        this.zadd(RedisKeyGenerator.Shop.getAllShopSortSetKey(), shopRo.getCreateTime().getTime(), RedisUtil.toByteArray((Long)shopRo.getId()));
    }

    public ShopRo findOne(Long shopId) {
        if (shopId == null) {
            return null;
        }
        String shopHashKey = RedisKeyGenerator.Shop.getShopHashKey(shopId);
        Map<byte[], byte[]> map = this.hgetAll(shopHashKey);
        if (MapUtils.isNotEmpty(map)) {
            ShopRo shopRo = new ShopRo();
            shopRo.fromMap(map);
            return shopRo;
        }
        return null;
    }

    public void delete(ShopRo shopRo) {
        this.del(RedisKeyGenerator.Shop.getShopHashKey(shopRo.getId()));
        this.zrem(RedisKeyGenerator.Shop.getAllShopSortSetKey(), new byte[][]{RedisUtil.toByteArray((Long)shopRo.getId())});
    }

    public ShopRo findByChannelAndChannelUserId(Integer channel, String channelUserId) {
        if (channel == null || StringUtils.isBlank((String)channelUserId)) {
            return null;
        }
        String channelAndChannelUserIdToShopIdHashKey = RedisKeyGenerator.Shop.getChannelAndChannelUserIdToShopIdHashKey(channel, channelUserId);
        byte[] bytes = this.get(channelAndChannelUserIdToShopIdHashKey);
        return bytes == null ? null : this.findOne(RedisUtil.byteArrayToLong((byte[])bytes));
    }

    public void updateBlackList(String[] list) {
        List<String> oldBlackList = this.getBlackList();
        ArrayList<String> newBlackList = new ArrayList<String>();
        if (list != null) {
            for (String tmpShopId : list) {
                String shopId = StringUtils.trimToEmpty((String)tmpShopId);
                newBlackList.add(shopId);
            }
        }
        oldBlackList.removeAll(newBlackList);
        for (String n : newBlackList) {
            this.zadd(RedisKeyGenerator.Shop.getBlackListShopKey(), System.currentTimeMillis(), RedisUtil.toByteArray((String)n));
        }
    }

    public void deleteBlackList(List<String> shopIds) {
        for (String shopId : shopIds) {
            this.zrem(RedisKeyGenerator.Shop.getBlackListShopKey(), new byte[][]{RedisUtil.toByteArray((String)shopId)});
        }
    }

    public List<String> getBlackList() {
        Object[] blackList = RedisUtil.bytesSetToStringArray(this.zRange(RedisKeyGenerator.Shop.getBlackListShopKey(), 0L, -1L));
        if (blackList == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])blackList);
    }

    public boolean getShopCanOrder(String shopId) {
        return this.zscore(RedisKeyGenerator.Shop.getBlackListShopKey(), RedisUtil.toByteArray((String)shopId)) == null;
    }
}

