/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.shop;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.shop.ShopTypeRo;
import com.depotnearby.common.shop.ShopTypeStatus;
import com.depotnearby.common.util.RedisUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.codelogger.utils.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class ShopTypeRedisDao
extends CommonRedisDao {
    public List<ShopTypeRo> findAll() {
        Set<byte[]> idBytesSet = this.zRange(RedisKeyGenerator.Shop.getAllShopTypeSortSetKey(), 0L, -1L);
        ArrayList shopTypeRos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(idBytesSet)) {
            for (byte[] idBytes : idBytesSet) {
                shopTypeRos.add(this.findOne(RedisUtil.byteArrayToLong((byte[])idBytes)));
            }
        }
        return shopTypeRos;
    }

    public List<ShopTypeRo> findAll(ShopTypeStatus shopTypeStatus) {
        Set<byte[]> idBytesSet = this.zRange(RedisKeyGenerator.Shop.getAllShopTypeOfStatusSortSetKey(shopTypeStatus), 0L, -1L);
        ArrayList shopTypeRos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(idBytesSet)) {
            for (byte[] idBytes : idBytesSet) {
                ShopTypeRo typeRo = this.findOne(RedisUtil.byteArrayToLong((byte[])idBytes));
                if (typeRo == null) continue;
                shopTypeRos.add(typeRo);
            }
        }
        return shopTypeRos;
    }

    public void save(ShopTypeRo shopTypeRo) {
        this.hmset(RedisKeyGenerator.Shop.getShopTypeHashKey(shopTypeRo.getId()), shopTypeRo.toMap());
        long currentTimeMillis = System.currentTimeMillis();
        this.zadd(RedisKeyGenerator.Shop.getAllShopTypeSortSetKey(), currentTimeMillis, RedisUtil.toByteArray((Long)shopTypeRo.getId()));
        if (Objects.equals(shopTypeRo.getStatus(), ShopTypeStatus.NORMAL.getValue())) {
            this.zadd(RedisKeyGenerator.Shop.getAllShopTypeOfStatusSortSetKey(ShopTypeStatus.NORMAL), currentTimeMillis, RedisUtil.toByteArray((Long)shopTypeRo.getId()));
        } else {
            this.zrem(RedisKeyGenerator.Shop.getAllShopTypeOfStatusSortSetKey(ShopTypeStatus.NORMAL), new byte[][]{RedisUtil.toByteArray((Long)shopTypeRo.getId())});
        }
    }

    public void update(ShopTypeRo shopTypeRo) {
        this.hmset(RedisKeyGenerator.Shop.getShopTypeHashKey(shopTypeRo.getId()), shopTypeRo);
    }

    public ShopTypeRo findOne(Long shopTypeId) {
        String userInfoKey = RedisKeyGenerator.Shop.getShopTypeHashKey(shopTypeId);
        Map<byte[], byte[]> map = this.hgetAll(userInfoKey);
        if (MapUtils.isNotEmpty(map)) {
            ShopTypeRo userInfo = new ShopTypeRo();
            userInfo.fromMap(map);
            return userInfo;
        }
        return null;
    }

    public void disableShopType(Long shopTypeId) {
        this.zrem(RedisKeyGenerator.Shop.getAllShopTypeOfStatusSortSetKey(ShopTypeStatus.NORMAL), new byte[][]{RedisUtil.toByteArray((Long)shopTypeId)});
    }

    public void delete(Long shopTypeId) {
        this.del(RedisKeyGenerator.Shop.getShopTypeHashKey(shopTypeId));
        this.zrem(RedisKeyGenerator.Shop.getAllShopTypeSortSetKey(), new byte[][]{RedisUtil.toByteArray((Long)shopTypeId)});
        this.zrem(RedisKeyGenerator.Shop.getAllShopTypeOfStatusSortSetKey(ShopTypeStatus.NORMAL), new byte[][]{RedisUtil.toByteArray((Long)shopTypeId)});
    }
}

