/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.sms;

import com.depotnearby.common.SMSType;
import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.vo.sms.SMSRo;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Component;

@Component
public class SMSRedisDao
extends CommonRedisDao {
    public void saveSMSCodeAndAutoExpire(String mobile, SMSType smsType, String code, int validTimeInSecond) {
        this.hmset(RedisKeyGenerator.SMS.getSmsCodeHashKey(mobile, smsType), new SMSRo(code, System.currentTimeMillis()).toMap());
        this.expire(RedisKeyGenerator.SMS.getSmsCodeHashKey(mobile, smsType), validTimeInSecond);
    }

    public SMSRo findSMSCode(String mobile, SMSType smsType) {
        Map<byte[], byte[]> data = this.hgetAll(RedisKeyGenerator.SMS.getSmsCodeHashKey(mobile, smsType));
        if (MapUtils.isNotEmpty(data)) {
            SMSRo smsRo = new SMSRo();
            smsRo.fromMap(data);
            return smsRo;
        }
        return null;
    }

    public void deleteSMSCode(String mobile, SMSType smsType) {
        this.del(RedisKeyGenerator.SMS.getSmsCodeHashKey(mobile, smsType));
    }
}

