/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.stock;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.po.mns.OssType;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.stock.DepotProductStockRo;
import com.depotnearby.common.ro.stock.MnsStockChangeRo;
import com.depotnearby.common.util.RedisUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.codelogger.utils.ArrayUtils;
import org.springframework.stereotype.Component;

@Component
public class StockRedisDao
extends CommonRedisDao {
    public static final int THREE_DAYS_TO_EXPIRE = 259200;

    public void save(DepotProductStockRo ro) {
        if (ro == null || StringUtils.isBlank((CharSequence)ro.getMcuCode()) || StringUtils.isBlank((CharSequence)ro.getCenterId())) {
            return;
        }
        this.hmset(RedisKeyGenerator.Stock.getDepotProductStockHashKey(ro.getMcuCode(), ro.getCenterId()), ro.toMap());
    }

    public void save(List<DepotProductStockRo> ros) {
        if (CollectionUtils.isEmpty(ros)) {
            return;
        }
        HashMap mcuCodeAndCenterIdToRo = Maps.newHashMap();
        for (DepotProductStockRo ro : ros) {
            String key;
            if (StringUtils.isBlank((CharSequence)ro.getMcuCode()) || StringUtils.isBlank((CharSequence)ro.getMcuCode()) || !StringUtils.isNotBlank((CharSequence)(key = RedisKeyGenerator.Stock.getDepotProductStockHashKey(ro.getMcuCode(), ro.getCenterId())))) continue;
            mcuCodeAndCenterIdToRo.put(key.getBytes(), ro.toMap());
        }
        super.pipeHmset(mcuCodeAndCenterIdToRo);
    }

    public DepotProductStockRo get(String mcuCode, String centerId) {
        if (StringUtils.isBlank((CharSequence)mcuCode) || StringUtils.isBlank((CharSequence)centerId)) {
            return null;
        }
        String stockInfoKey = RedisKeyGenerator.Stock.getDepotProductStockHashKey(mcuCode, centerId);
        Map<byte[], byte[]> map = this.hgetAll(stockInfoKey);
        if (MapUtils.isNotEmpty(map)) {
            DepotProductStockRo ro = new DepotProductStockRo();
            ro.fromMap(map);
            return ro;
        }
        return null;
    }

    public Long incDepotProductStock(String depotCode, String centerId, int quantity) {
        return super.hincrBy(RedisKeyGenerator.Stock.getDepotProductStockHashKey(depotCode, centerId), "quantity".getBytes(), quantity);
    }

    public Long updateDepotProductStock(String depotCode, String centerId, int quantity) {
        return super.hset(RedisKeyGenerator.Stock.getDepotProductStockHashKey(depotCode, centerId), "quantity", RedisUtil.toByteArray((Integer)quantity));
    }

    public Long incDepotProductBlockStock(String mcuCode, String centerId, int quantity) {
        Long blockCount = super.incrBy(RedisKeyGenerator.Stock.getDepotProductBlockStockKey(mcuCode, centerId), quantity);
        if (blockCount < 0L) {
            super.set(RedisKeyGenerator.Stock.getDepotProductBlockStockKey(mcuCode, centerId), RedisUtil.toBitByteArray((int)0));
            blockCount = 0L;
        }
        return blockCount;
    }

    public Integer getDepotProductBlockStock(String mcuCode, String centerId) {
        byte[] b = super.get(RedisKeyGenerator.Stock.getDepotProductBlockStockKey(mcuCode, centerId));
        if (ArrayUtils.isNotEmpty((Object)b) && NumberUtils.isNumber((String)new String(b))) {
            return RedisUtil.byteArrayToInt((byte[])b);
        }
        return 0;
    }

    public void saveChange(MnsStockChangeRo ro) {
        if (ro == null || ro.getId() == null) {
            return;
        }
        String key = RedisKeyGenerator.Stock.getDepotProductStockChangeHashKey(ro.getId());
        this.hmset(key, ro.toMap());
        this.expire(key, 259200);
    }

    public boolean existDoneStockChangeId(Long id) {
        return super.exists(RedisKeyGenerator.Stock.getDepotProductDoneStockChangeIdStringKey(id));
    }

    public MnsStockChangeRo findOne(Long id) {
        if (id == null) {
            return null;
        }
        String key = RedisKeyGenerator.Stock.getDepotProductStockChangeHashKey(id);
        Map<byte[], byte[]> map = this.hgetAll(key);
        if (MapUtils.isNotEmpty(map)) {
            MnsStockChangeRo ro = new MnsStockChangeRo();
            ro.fromMap(map);
            return ro;
        }
        return null;
    }

    public void saveDoneStockChange(Long changeId, String bill) {
        if (changeId != null) {
            super.setex(RedisKeyGenerator.Stock.getDepotProductDoneStockChangeIdStringKey(changeId), 259200, RedisUtil.toByteArray((String)bill));
        }
    }

    public void saveDepotProductToBeRemovedKeys(OssType ossType, List<String> depotProductKeys) {
        if (CollectionUtils.isEmpty(depotProductKeys)) {
            return;
        }
        ArrayList keys = Lists.newArrayList();
        for (String key : depotProductKeys) {
            keys.add(key);
            if (keys.size() != 500) continue;
            super.sadd(RedisKeyGenerator.Stock.getDepotProductToBeRemovedSetKey(ossType.getName()), (String[])ArrayUtils.toArray(depotProductKeys));
            keys.clear();
        }
        super.sadd(RedisKeyGenerator.Stock.getDepotProductToBeRemovedSetKey(ossType.getName()), (String[])ArrayUtils.toArray(depotProductKeys));
    }

    public Long removeValidDepotProductKeys(OssType ossType, List<String> validDepotProductKeys) {
        return super.srem(RedisKeyGenerator.Stock.getDepotProductToBeRemovedSetKey(ossType.getName()), (String[])ArrayUtils.toArray(validDepotProductKeys));
    }

    public List<String> getInvalidDepotProductKeys(OssType ossType) {
        Set<byte[]> bytes = super.smembers(RedisKeyGenerator.Stock.getDepotProductToBeRemovedSetKey(ossType.getName()));
        return RedisUtil.bytesSetToStringList(bytes);
    }

    public void cleanDepotProductKeys(OssType ossType) {
        super.del(RedisKeyGenerator.Stock.getDepotProductToBeRemovedSetKey(ossType.getName()));
    }

    public void deleteByKeys(List<String> keys) {
        super.pipeDel(keys);
    }
}

