/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.upgrade;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.upgrade.UpgradeRo;
import com.depotnearby.common.util.RedisUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpgradeRedisDao
extends CommonRedisDao {
    private final Logger logger = LoggerFactory.getLogger(UpgradeRedisDao.class);

    public void save(UpgradeRo ro) {
        String os = ro.getOs();
        long score = ro.versionToSroce();
        String setKey = RedisKeyGenerator.Upgrade.getUpgradeSortSetKey(os);
        this.zadd(setKey, score, RedisUtil.toByteArray((String)ro.getId()));
        this.hmset(RedisKeyGenerator.Upgrade.getUpgradeHashKey(ro.getId()), ro.toMap());
    }

    public UpgradeRo getUpgradeRo(String id) {
        Map<byte[], byte[]> map = this.hgetAll(RedisKeyGenerator.Upgrade.getUpgradeHashKey(id));
        this.logger.debug("use key :{}", (Object)RedisKeyGenerator.Upgrade.getUpgradeHashKey(id));
        if (map == null || map.isEmpty()) {
            return null;
        }
        UpgradeRo upgrade = new UpgradeRo();
        upgrade.fromMap(map);
        return upgrade;
    }

    public void delete(String id) {
        UpgradeRo upgrade = this.getUpgradeRo(id);
        if (upgrade != null) {
            String setKey = RedisKeyGenerator.Upgrade.getUpgradeSortSetKey(upgrade.getOs());
            this.zrem(setKey, id);
            this.del(RedisKeyGenerator.Upgrade.getUpgradeHashKey(id));
        }
    }

    public List<UpgradeRo> findAll(String os) {
        Set<byte[]> ids = super.zRange(RedisKeyGenerator.Upgrade.getUpgradeSortSetKey(os), 0L, -1L);
        ArrayList<UpgradeRo> result = new ArrayList<UpgradeRo>();
        if (ids != null && !ids.isEmpty()) {
            for (byte[] idArr : ids) {
                String id = new String(idArr);
                UpgradeRo upgrade = this.getUpgradeRo(id);
                if (upgrade == null) continue;
                result.add(upgrade);
            }
        }
        return result;
    }

    public UpgradeRo needUpgrade(String os, String version, boolean inHourse) {
        String setKey = RedisKeyGenerator.Upgrade.getUpgradeSortSetKey(os);
        long score = UpgradeRo.versionToSroce(version);
        this.logger.debug(" current score {}", (Object)score);
        UpgradeRo result = null;
        Set<byte[]> ids = super.zrevrangeByScore(setKey, String.valueOf(Long.MAX_VALUE), "(" + score);
        if (ids != null && !ids.isEmpty()) {
            this.logger.debug(" size : {}", (Object)ids.size());
            for (byte[] idArr : ids) {
                String id = new String(idArr);
                this.logger.debug(" id : {}", (Object)id);
                UpgradeRo upgrade = this.getUpgradeRo(id);
                this.logger.debug("{} is null {}", (Object)id, (Object)(upgrade == null ? 1 : 0));
                if (upgrade == null || inHourse != upgrade.getInhourse()) continue;
                if (result == null) {
                    result = upgrade;
                }
                this.logger.debug("result is null {}", (Object)(result == null ? 1 : 0));
                if (!upgrade.getForce()) continue;
                result.setForce(true);
                return result;
            }
        }
        return result;
    }
}

