/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.user;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.user.RecommendUserRo;
import com.depotnearby.common.util.RedisUtil;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Component;

@Component
public class RecommendUserRedisDao
extends CommonRedisDao {
    public void save(RecommendUserRo recommendUserRo) {
        this.hmset(RedisKeyGenerator.User.getRecommendUserHashKey(recommendUserRo.getTel()), recommendUserRo.toMap());
    }

    public RecommendUserRo getRecommendUserRo(String tel) {
        if (tel == null) {
            return null;
        }
        Map<byte[], byte[]> map = this.hgetAll(RedisKeyGenerator.User.getRecommendUserHashKey(tel));
        if (MapUtils.isNotEmpty(map)) {
            RecommendUserRo ro = new RecommendUserRo();
            ro.fromMap(map);
            return ro;
        }
        return null;
    }

    public void delete(String tel) {
        this.del(RedisKeyGenerator.User.getRecommendUserHashKey(tel));
    }

    public Long incRecommendUserCount(String userId, String ts) {
        Long num = this.hincrBy(RedisKeyGenerator.User.getShareTimesKey(), RedisUtil.toByteArray((String)(userId + ":" + ts)), 1L);
        return num;
    }
}

