/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.user;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.user.UserRo;
import com.depotnearby.common.shop.ShopChannel;
import com.depotnearby.common.util.RedisUtil;
import com.depotnearby.util.StringTool;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.codelogger.utils.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class UserRedisDao
extends CommonRedisDao {
    public void save(UserRo user) {
        this.hmset(RedisKeyGenerator.User.getUserInfoHashKey(user.getId()), user.toMap());
        this.mapMobile2User(user.getMobile(), user.getId());
        Timestamp createTime = user.getCreateTime();
        this.zadd(RedisKeyGenerator.User.getAllUserSortSetKey(), createTime == null ? (double)System.currentTimeMillis() : (double)createTime.getTime(), RedisUtil.toByteArray((Long)user.getId()));
    }

    public void mapMobile2User(String mobile, Long userId) {
        String key = RedisKeyGenerator.User.getMobileToUserIdHashKey(mobile);
        this.set(key, RedisUtil.toByteArray((Long)userId));
    }

    public void removeMapMobileToUser(String mobile) {
        String[] keyAndField = RedisKeyGenerator.User.getMobileKeyAndField(mobile);
        this.hdel(keyAndField[0], keyAndField[1]);
        this.del(RedisKeyGenerator.User.getMobileToUserIdHashKey(mobile));
    }

    public Long getUserIdByMobile(String mobile) {
        Long userId = this.getUserIdByMobileMap(mobile);
        if (userId == null) {
            String[] keyAndField = RedisKeyGenerator.User.getMobileKeyAndField(mobile);
            byte[] bytes = this.hget(keyAndField[0], keyAndField[1]);
            return bytes == null ? null : RedisUtil.byteArrayToLong((byte[])bytes);
        }
        return userId;
    }

    private Long getUserIdByMobileMap(String mobile) {
        String mobileToUserIdHashKey = RedisKeyGenerator.User.getMobileToUserIdHashKey(mobile);
        byte[] bytes = this.get(mobileToUserIdHashKey);
        return bytes == null ? null : RedisUtil.byteArrayToLong((byte[])bytes);
    }

    public Long getUserIdByShopChannelAndChannelUserId(ShopChannel shopChannel, String channelUserId) {
        String channelUserIdHashKey = RedisKeyGenerator.User.getChannelUserIdToUserIdHashKey(shopChannel, channelUserId);
        byte[] bytes = this.get(channelUserIdHashKey);
        return bytes == null ? null : RedisUtil.byteArrayToLong((byte[])bytes);
    }

    public void mapShopChannelAndChannelIdToUser(ShopChannel shopChannel, String channelUserId, Long userId) {
        String key = RedisKeyGenerator.User.getChannelUserIdToUserIdHashKey(shopChannel, channelUserId);
        this.set(key, RedisUtil.toByteArray((Long)userId));
    }

    public Long getChannelUserIdByShopChannelAndChannelMobile(ShopChannel shopChannel, String channelMobile) {
        String channelUserIdHashKey = RedisKeyGenerator.User.getChannelMobileToChannelUserIdHashKey(shopChannel, channelMobile);
        byte[] bytes = this.get(channelUserIdHashKey);
        return bytes == null ? null : RedisUtil.byteArrayToLong((byte[])bytes);
    }

    public void mapShopChannelAndChannelMobileToChannelUserId(ShopChannel shopChannel, String channelMobile, String channelUserId) {
        String key = RedisKeyGenerator.User.getChannelMobileToChannelUserIdHashKey(shopChannel, channelMobile);
        this.set(key, RedisUtil.toByteArray((String)channelUserId));
    }

    public UserRo get(Long userId) {
        if (userId == null) {
            return null;
        }
        String userInfoKey = RedisKeyGenerator.User.getUserInfoHashKey(userId);
        Map<byte[], byte[]> map = this.hgetAll(userInfoKey);
        if (MapUtils.isNotEmpty(map)) {
            UserRo userInfo = new UserRo();
            userInfo.fromMap(map);
            return userInfo;
        }
        return null;
    }

    public UserRo getUserByMobile(String mobile) {
        if (!StringTool.isMobileValid((String)mobile)) {
            return null;
        }
        Long userIdByMobile = this.getUserIdByMobile(mobile);
        UserRo userRo = this.get(userIdByMobile);
        if (userRo != null && !mobile.equalsIgnoreCase(userRo.getMobile())) {
            return null;
        }
        return userRo;
    }

    public void updateUserPassword(String mobile, String password, String originalPassword) {
        UserRo userRo = this.getUserByMobile(mobile);
        userRo.setPassword(password);
        userRo.setOriginalPassword(originalPassword);
        this.save(userRo);
    }

    public void delete(UserRo userRo) {
        if (userRo != null) {
            String[] keyAndField = RedisKeyGenerator.User.getMobileKeyAndField(userRo.getMobile());
            this.hdel(keyAndField[0], keyAndField[1]);
            this.del(RedisKeyGenerator.User.getMobileToUserIdHashKey(userRo.getMobile()));
            this.del(RedisKeyGenerator.User.getUserInfoHashKey(userRo.getId()));
            this.zrem(RedisKeyGenerator.User.getAllUserSortSetKey(), new byte[][]{RedisUtil.toByteArray((Long)userRo.getId())});
        }
    }

    public void saveWithToken(Long userId, String deviceId, String token, String userAgent) {
        this.hset(RedisKeyGenerator.User.getUserInfoHashKey(userId), "lastLoginDeviceToken", RedisUtil.toByteArray((String)StringUtils.defaultString((String)deviceId)));
        this.hset(RedisKeyGenerator.User.getUserInfoHashKey(userId), "lastToken", RedisUtil.toByteArray((String)StringUtils.defaultString((String)token)));
        this.hset(RedisKeyGenerator.User.getUserInfoHashKey(userId), "lastUserAgent", RedisUtil.toByteArray((String)StringUtils.defaultString((String)userAgent)));
    }

    public void clearToken(Long userId, String token, String userAgent) {
        this.hset(RedisKeyGenerator.User.getUserInfoHashKey(userId), "lastToken", RedisUtil.toByteArray((String)StringUtils.defaultString((String)token)));
        this.hset(RedisKeyGenerator.User.getUserInfoHashKey(userId), "lastUserAgent", RedisUtil.toByteArray((String)StringUtils.defaultString((String)userAgent)));
    }

    public void putRegisterFailedUserId(Long userId) {
        this.zadd(RedisKeyGenerator.User.getRegisterFailedUserHashKey(), System.currentTimeMillis(), RedisUtil.toByteArray((Long)userId));
    }

    public List<UserRo> getSyncFailedUsers() {
        List userIds = RedisUtil.bytesSetToLongList(this.zRange(RedisKeyGenerator.User.getRegisterFailedUserHashKey(), 0L, -1L));
        ArrayList users = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)userIds)) {
            for (Long userId : userIds) {
                users.add(this.get(userId));
            }
        }
        return users;
    }

    public void removeSyncFailedUser(Long userId) {
        this.zrem(RedisKeyGenerator.User.getRegisterFailedUserHashKey(), new byte[][]{RedisUtil.toByteArray((Long)userId)});
    }

    public void putResetPwdToOMSFailedUserId(Long userId) {
        this.zadd(RedisKeyGenerator.User.getResetPwdToOMSFailedUserHashKey(), System.currentTimeMillis(), RedisUtil.toByteArray((Long)userId));
    }

    public boolean getUserCanOrder(String mobile) {
        return this.zscore(RedisKeyGenerator.User.getBlockCreateOrderUserKey(), RedisUtil.toByteArray((String)mobile)) == null;
    }

    public List<String> getBlackList() {
        Object[] blackList = RedisUtil.bytesSetToStringArray(this.zRange(RedisKeyGenerator.User.getBlockCreateOrderUserKey(), 0L, -1L));
        if (blackList == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])blackList);
    }

    public void updateBlackList(String[] list) {
        List<String> oldBlackList = this.getBlackList();
        ArrayList<String> newBlackList = new ArrayList<String>();
        if (list != null) {
            for (String s : list) {
                String fixedMobile = StringUtils.trimToEmpty((String)s);
                if (fixedMobile.length() != 11) continue;
                newBlackList.add(fixedMobile);
            }
        }
        oldBlackList.removeAll(newBlackList);
        for (String old : oldBlackList) {
            this.zrem(RedisKeyGenerator.User.getBlockCreateOrderUserKey(), new byte[][]{RedisUtil.toByteArray((String)old)});
        }
        for (String n : newBlackList) {
            this.zadd(RedisKeyGenerator.User.getBlockCreateOrderUserKey(), System.currentTimeMillis(), RedisUtil.toByteArray((String)n));
        }
    }
}

