/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.voucher;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.po.voucher.VoucherExpireType;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.voucher.VoucherRo;
import com.depotnearby.common.ro.voucher.VoucherTypeRo;
import com.depotnearby.common.util.RedisUtil;
import com.depotnearby.dao.redis.voucher.VoucherTypeRedisDao;
import com.depotnearby.util.DateTool;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codelogger.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VoucherRedisDao
extends CommonRedisDao {
    private static final Logger logger = LoggerFactory.getLogger(VoucherRedisDao.class);
    @Autowired
    VoucherTypeRedisDao voucherTypeRedisDao;

    public VoucherRo getVoucherRo(Long id) {
        Map<byte[], byte[]> map = this.hgetAll(RedisKeyGenerator.Voucher.getVoucherHashKey(id));
        if (map == null || map.isEmpty()) {
            return null;
        }
        VoucherRo ro = new VoucherRo();
        ro.fromMap(map);
        return ro;
    }

    public VoucherRo bindVoucherToUser(Long userId, VoucherTypeRo voucherType) {
        Long voucherTypeId = voucherType.getId();
        byte[] bytes = this.lpop(RedisKeyGenerator.VoucherType.getVoucherTypeVoucherListKey(voucherTypeId));
        if (bytes != null) {
            Long voucherId = RedisUtil.byteArrayToLong((byte[])bytes);
            VoucherRo voucherRo = this.getVoucherRo(voucherId);
            if (voucherRo != null) {
                voucherRo.setBindingUserId(userId);
                voucherRo.setCreateTime(System.currentTimeMillis());
                voucherRo.setExpireTime(voucherType.getVoucherExpireType() == VoucherExpireType.EXPIRE_BY_PERIOD ? DateTool.afterDays((int)voucherType.getPeriodDays()) : voucherType.getExpireTime());
                this.hmset(RedisKeyGenerator.Voucher.getVoucherHashKey(voucherId), voucherRo.toMap());
                this.move(voucherRo.getId(), null, RedisKeyGenerator.Voucher.getUserAllVouchersSortSetKey(userId));
                this.move(voucherRo.getId(), null, RedisKeyGenerator.Voucher.getUserVoucherUnusedSortSetKey(userId));
                return voucherRo;
            }
            logger.error("voucher id : {} is not exists", (Object)voucherId);
        } else {
            logger.error("voucher id queue  for {} is empty", (Object)voucherType.getId());
        }
        return null;
    }

    public void use(Long userId, Long voucherRoId) {
        VoucherRo voucherRo = new VoucherRo();
        voucherRo.fromMap(this.hgetAll(RedisKeyGenerator.Voucher.getVoucherHashKey(voucherRoId)));
        if (new Date().getTime() > voucherRo.getExpireTime()) {
            this.move(voucherRoId, RedisKeyGenerator.Voucher.getUserVoucherUnusedSortSetKey(userId), RedisKeyGenerator.Voucher.getUserVoucherExpiredSortSetKey(userId));
        } else {
            this.move(voucherRoId, RedisKeyGenerator.Voucher.getUserVoucherUnusedSortSetKey(userId), RedisKeyGenerator.Voucher.getUserVoucherUsedSortSetKey(userId));
        }
    }

    public void expire(Long userId, Long voucherRoId) {
        this.move(voucherRoId, RedisKeyGenerator.Voucher.getUserVoucherUnusedSortSetKey(userId), RedisKeyGenerator.Voucher.getUserVoucherUsedSortSetKey(userId));
    }

    public List<VoucherRo> listAllUsableVoucher(Long userId) {
        return this.getVouchers(RedisKeyGenerator.Voucher.getUserVoucherUnusedSortSetKey(userId), null);
    }

    public Map<String, List<VoucherRo>> allVouchers(Long userId) {
        HashMap map = Maps.newHashMap();
        List<VoucherRo> unusedVouchers = this.getUnusedVouchers(RedisKeyGenerator.Voucher.getUserVoucherUnusedSortSetKey(userId));
        ArrayList useableVoucherRos = Lists.newArrayList();
        ArrayList usedVoucherRos = Lists.newArrayList();
        ArrayList expiredVoucherRos = Lists.newArrayList();
        for (VoucherRo unusedVoucher : unusedVouchers) {
            if (unusedVoucher.getUseTime() == null) {
                if (unusedVoucher.getExpireTime() != null && unusedVoucher.getExpireTime() < System.currentTimeMillis()) {
                    VoucherTypeRo voucherType = this.voucherTypeRedisDao.getVoucherTypeRoById(unusedVoucher.getVoucherTypeId());
                    if (voucherType != null && voucherType.getVoucherExpireType() == VoucherExpireType.EXPIRE_BY_PERIOD) {
                        expiredVoucherRos.add(unusedVoucher);
                        continue;
                    }
                    if (voucherType != null && voucherType.getExpireTime() < System.currentTimeMillis()) {
                        expiredVoucherRos.add(unusedVoucher);
                        continue;
                    }
                    useableVoucherRos.add(unusedVoucher);
                    continue;
                }
                useableVoucherRos.add(unusedVoucher);
                continue;
            }
            usedVoucherRos.add(unusedVoucher);
        }
        map.put("unused", useableVoucherRos);
        map.put("used", this.getVouchers(RedisKeyGenerator.Voucher.getUserVoucherUsedSortSetKey(userId), null));
        map.put("expired", this.getVouchers(RedisKeyGenerator.Voucher.getUserVoucherExpiredSortSetKey(userId), expiredVoucherRos));
        return map;
    }

    public int getVoucherTypeVoucherCount(Long voucherTypeId) {
        return new Long(this.llen(RedisKeyGenerator.VoucherType.getVoucherTypeVoucherListKey(voucherTypeId))).intValue();
    }

    private void move(Long voucherRoId, String from, String to) {
        if (StringUtils.isEmpty((String)to)) {
            return;
        }
        if (StringUtils.isNotBlank((String)from)) {
            this.srem(from, RedisUtil.toByteArray((Long)voucherRoId));
        }
        this.sadd(to, RedisUtil.toByteArray((Long)voucherRoId));
    }

    public List<VoucherRo> getVouchers(String key, List<VoucherRo> vrs) {
        ArrayList voucherRos = Lists.newArrayList();
        for (byte[] voucherId : this.smembers(key)) {
            VoucherRo voucherRo = this.getVoucherRo(RedisUtil.byteArrayToLong((byte[])voucherId));
            if (voucherRo == null) continue;
            voucherRos.add(voucherRo);
        }
        if (vrs != null) {
            voucherRos.addAll(vrs);
        }
        return voucherRos;
    }

    public List<VoucherRo> getUnusedVouchers(String key) {
        ArrayList unusedVoucherRos = Lists.newArrayList();
        for (byte[] voucherId : this.smembers(key)) {
            VoucherRo voucherRo = new VoucherRo();
            voucherRo.fromMap(this.hgetAll(RedisKeyGenerator.Voucher.getVoucherHashKey(RedisUtil.byteArrayToLong((byte[])voucherId))));
            unusedVoucherRos.add(voucherRo);
        }
        return unusedVoucherRos;
    }

    public List<VoucherRo> getVouchersByType(List<VoucherTypeRo> allVoucherTypes) {
        ArrayList voucherRos = Lists.newArrayList();
        String key = "";
        if (allVoucherTypes != null && allVoucherTypes.size() > 0) {
            for (VoucherTypeRo voucherTypeRo : allVoucherTypes) {
                key = RedisKeyGenerator.VoucherType.getVoucherTypeVoucherListKey(voucherTypeRo.getId());
                for (byte[] voucherId : this.smembers(key)) {
                    VoucherRo voucherRo = new VoucherRo();
                    voucherRo.fromMap(this.hgetAll(RedisKeyGenerator.Voucher.getVoucherHashKey(RedisUtil.byteArrayToLong((byte[])voucherId))));
                    if (voucherRo.getBindingUserId() == null || voucherRo.getUseTime() != null || voucherRo.getExpireTime() >= System.currentTimeMillis()) continue;
                    voucherRos.add(voucherRo);
                }
            }
        }
        return voucherRos;
    }
}

