/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.voucher;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.ro.voucher.VoucherRo;
import com.depotnearby.common.ro.voucher.VoucherTypeRo;
import com.depotnearby.common.util.RedisUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Component;

@Component
public class VoucherTypeRedisDao
extends CommonRedisDao {
    public void save(VoucherTypeRo voucherTypeRo) {
        this.sadd(RedisKeyGenerator.VoucherType.getVoucherTypeSortSetKey(), RedisUtil.toByteArray((Long)voucherTypeRo.getId()));
        this.hmset(RedisKeyGenerator.VoucherType.getVoucherTypeHashKey(voucherTypeRo.getId()), voucherTypeRo.toMap());
    }

    public void syncVoucherList(Long voucherTypeId, List<VoucherRo> vouchers) {
        for (VoucherRo voucher : vouchers) {
            this.lpush(RedisKeyGenerator.VoucherType.getVoucherTypeVoucherListKey(voucherTypeId), new byte[][]{RedisUtil.toByteArray((Long)voucher.getId())});
            this.hmset(RedisKeyGenerator.Voucher.getVoucherHashKey(voucher.getId()), voucher.toMap());
        }
    }

    public List<VoucherTypeRo> allVoucherTypes() {
        ArrayList voucherTypeRos = Lists.newArrayList();
        for (byte[] idBytes : this.smembers(RedisKeyGenerator.VoucherType.getVoucherTypeSortSetKey())) {
            Long voucherTypeId = RedisUtil.byteArrayToLong((byte[])idBytes);
            VoucherTypeRo voucherTypeRo = this.getVoucherTypeRoById(voucherTypeId);
            if (voucherTypeRo == null) continue;
            voucherTypeRos.add(voucherTypeRo);
            voucherTypeRo.setIssueCount(this.getVoucherIssueCount(voucherTypeId));
        }
        return voucherTypeRos;
    }

    public VoucherTypeRo getVoucherTypeRoById(Long id) {
        Map<byte[], byte[]> map = this.hgetAll(RedisKeyGenerator.VoucherType.getVoucherTypeHashKey(id));
        if (MapUtils.isNotEmpty(map)) {
            VoucherTypeRo voucherTypeRo = new VoucherTypeRo();
            voucherTypeRo.fromMap(map);
            voucherTypeRo.setIssueCount(this.getVoucherIssueCount(id));
            return voucherTypeRo;
        }
        return null;
    }

    private Integer getVoucherIssueCount(Long voucherTypeId) {
        return (int)this.llen(RedisKeyGenerator.VoucherType.getVoucherTypeVoucherListKey(voucherTypeId));
    }
}

