/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.dao.redis.ximu;

import com.depotnearby.common.dao.redis.CommonRedisDao;
import com.depotnearby.common.ro.RedisKeyGenerator;
import com.depotnearby.common.util.RedisUtil;
import com.depotnearby.vo.ximu.constants.XiMuUploadFileType;
import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class XimuRedisDao
extends CommonRedisDao {
    private final Logger logger = LoggerFactory.getLogger(XimuRedisDao.class);

    public Long getXimuAgreeDateCode(String dateStr) {
        return this.hincrBy(RedisKeyGenerator.Ximu.getXimuAgreeDateCodeKey(StringUtils.left((String)dateStr, (int)4)), RedisUtil.toByteArray((String)StringUtils.right((String)dateStr, (int)2)), 1L);
    }

    public void saveXimuLatestSyncTimestamp(XiMuUploadFileType type, Timestamp timestamp) {
        this.set(RedisKeyGenerator.Ximu.getXimuFileLatestSyncTimestampKey(type.getName()), RedisUtil.toByteArray((Long)timestamp.getTime()));
    }

    public Timestamp getXimuLatestSyncTimestamp(XiMuUploadFileType type) {
        byte[] bytes = this.get(RedisKeyGenerator.Ximu.getXimuFileLatestSyncTimestampKey(type.getName()));
        return ArrayUtils.isEmpty((byte[])bytes) || !NumberUtils.isNumber((String)RedisUtil.byteArrayToStr((byte[])bytes)) ? null : new Timestamp(Long.valueOf(RedisUtil.byteArrayToStr((byte[])bytes)));
    }

    public void deleteXimuLatestSyncTimestamp(XiMuUploadFileType type) {
        this.del(RedisKeyGenerator.Ximu.getXimuFileLatestSyncTimestampKey(type.getName()));
    }
}

