/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.util;

import com.depotnearby.common.mo.email.EmailMessage;
import com.depotnearby.exception.CommonException;
import com.depotnearby.service.MQServiceFactory;
import com.depotnearby.vo.mq.MQMessage;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMailUtil {
    private static Logger logger = LoggerFactory.getLogger(SendMailUtil.class);
    public static List<String> mailList = null;

    public static void sendExceptionMail(String subject, String content, List<String> receiveMailList) {
        if (receiveMailList == null || receiveMailList.size() == 0) {
            throw new RuntimeException("\u5173\u952e\u4efb\u52a1\u5f02\u5e38\u53d1\u9001\u901a\u77e5\u90ae\u4ef6\uff1a\u6536\u4ef6\u4eba\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        EmailMessage mail = new EmailMessage();
        mail.setSubject(subject);
        mail.setContent(content);
        mail.addToAddrs(receiveMailList);
        try {
            MQMessage msg = new MQMessage("emailqueue", (Object)mail, Long.valueOf(TimeUnit.SECONDS.toMillis(10L)), Integer.valueOf(5), null);
            MQServiceFactory.getService().sendMessage(msg);
        }
        catch (CommonException e) {
            logger.error("Send mail message Exception", (Throwable)e);
        }
    }

    public static void sendExceptionMail(String subject, String content, String receiveMail) {
        ArrayList<String> receivers = new ArrayList<String>();
        receivers.add(receiveMail);
        SendMailUtil.sendExceptionMail(subject, content, receivers);
    }

    public static void sendExceptionMail(String subject, Exception exception, String to) {
        try {
            ArrayList<String> receivers = new ArrayList<String>();
            receivers.add(to);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream p = new PrintStream(os);
            exception.printStackTrace(p);
            EmailMessage mail = new EmailMessage();
            mail.setSubject(subject);
            mail.setContent(new String(os.toByteArray()));
            mail.addToAddrs(receivers);
            MQMessage msg = new MQMessage("emailqueue", (Object)mail, Long.valueOf(TimeUnit.SECONDS.toMillis(10L)), Integer.valueOf(5), null);
            MQServiceFactory.getService().sendMessage(msg);
        }
        catch (CommonException e) {
            logger.error("Send mail message Exception", (Throwable)e);
        }
    }

    public static void sendExceptionMail(String subject, Exception exception) {
        try {
            ArrayList<String> receivers = new ArrayList<String>();
            receivers.add("defei.deng@biz-united.com.cn");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream p = new PrintStream(os);
            exception.printStackTrace(p);
            EmailMessage mail = new EmailMessage();
            mail.setSubject(subject);
            mail.setContent(new String(os.toByteArray()));
            mail.addToAddrs(receivers);
            MQMessage msg = new MQMessage("emailqueue", (Object)mail, Long.valueOf(TimeUnit.SECONDS.toMillis(10L)), Integer.valueOf(5), null);
            MQServiceFactory.getService().sendMessage(msg);
        }
        catch (CommonException e) {
            logger.error("Send mail message Exception", (Throwable)e);
        }
    }

    public static void sendExceptionMailDefault(String subject, Exception exception) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream p = new PrintStream(os);
            exception.printStackTrace(p);
            EmailMessage mail = new EmailMessage();
            mail.setSubject(subject);
            mail.setContent(new String(os.toByteArray()));
            mail.addToAddrs(mailList);
            MQMessage msg = new MQMessage("emailqueue", (Object)mail, Long.valueOf(TimeUnit.SECONDS.toMillis(10L)), Integer.valueOf(5), null);
            MQServiceFactory.getService().sendMessage(msg);
        }
        catch (CommonException e) {
            logger.error("Send mail message Exception", (Throwable)e);
        }
    }

    public static void sendExceptionMailDefault(String subject, String content) {
        SendMailUtil.sendExceptionMail(subject, content, mailList);
    }

    static {
        mailList = new ArrayList<String>();
        mailList.add("defei.deng@biz-united.com.cn");
    }
}

