/*
 * Decompiled with CFR 0.152.
 */
package com.ximucredit.util;

import com.depotnearby.exception.CommonException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLPostRequest {
    private static final Logger log = LoggerFactory.getLogger(SSLPostRequest.class);
    private static final String KEY_STORE_TYPE_JKS = "jks";
    private static final String KEY_STORE_TYPE_P12 = "PKCS12";
    private static final String KEY_FACTORY_ALGORITHM = "sunx509";
    private static final String KEY_SSL_CONTEXT_PROTOCOL = "SSL";
    private static final String KEY_STORE_TRUST_PASSWORD = "123456";
    public static String KEY_STORE_CLIENT_PATH;
    public static String KEY_STORE_TRUST_PATH;
    public static String KEY_STORE_PASSWORD;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestByPostMethod(Map<String, String> map, String url) throws CommonException {
        if (KEY_STORE_CLIENT_PATH == null || KEY_STORE_TRUST_PATH == null) {
            throw new RuntimeException("\u5f99\u6728\u901a\u8baf\u8bc1\u4e66\u6216\u6388\u4fe1\u6587\u4ef6\u4e3a\u7a7a");
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String content = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE_P12);
            KeyStore trustStore = KeyStore.getInstance(KEY_STORE_TYPE_JKS);
            FileInputStream ksIn = new FileInputStream(KEY_STORE_CLIENT_PATH);
            FileInputStream tsIn = new FileInputStream(new File(KEY_STORE_TRUST_PATH));
            try {
                keyStore.load(ksIn, KEY_STORE_PASSWORD.toCharArray());
                trustStore.load(tsIn, KEY_STORE_TRUST_PASSWORD.toCharArray());
            }
            finally {
                try {
                    ((InputStream)ksIn).close();
                }
                catch (Exception exception) {}
                try {
                    ((InputStream)tsIn).close();
                }
                catch (Exception exception) {}
            }
            KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KEY_FACTORY_ALGORITHM);
            keyFactory.init(keyStore, KEY_STORE_PASSWORD.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(KEY_FACTORY_ALGORITHM);
            tmf.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance(KEY_SSL_CONTEXT_PROTOCOL);
            sslContext.init(keyFactory.getKeyManagers(), tmf.getTrustManagers(), null);
            SSLConnectionSocketFactory sslCSF = new SSLConnectionSocketFactory(sslContext);
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslCSF).build();
            HttpPost post = new HttpPost(url);
            ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
            for (String key : map.keySet()) {
                list.add(new BasicNameValuePair(key, map.get(key)));
            }
            UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(list, "UTF-8");
            post.setEntity((HttpEntity)uefEntity);
            System.out.println("POST \u8bf7\u6c42\uff1a" + post.getURI());
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)post);
            content = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        }
        catch (Exception e) {
            log.error("\u5f99\u6728\u8bf7\u6c42\u51fa\u9519...", (Throwable)e);
            throw new CommonException((Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return content;
    }
}

