/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis.bean;

import com.ec.primus.redis.bean.BaseRedisObject;
import com.ec.primus.redis.util.RedisUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import redis.clients.util.JedisByteHashMap;

public class RedisObjMap {
    private JedisByteHashMap serialMap;

    public JedisByteHashMap getSerialMap() {
        return this.serialMap;
    }

    public void setSerialMap(JedisByteHashMap serialMap) {
        this.serialMap = serialMap;
    }

    public RedisObjMap() {
        this(null);
    }

    public RedisObjMap(Map<byte[], byte[]> map) {
        if (map == null) {
            this.serialMap = new JedisByteHashMap();
        } else if (map instanceof JedisByteHashMap) {
            this.serialMap = (JedisByteHashMap)map;
        } else {
            this.serialMap = new JedisByteHashMap();
            this.serialMap.putAll(map);
        }
    }

    protected void put(String key, byte[] value) {
        if (key != null) {
            this.serialMap.put(key.getBytes(), value);
        }
    }

    public byte[] getBytes(String key) {
        return key == null || this.serialMap == null ? null : this.serialMap.get((Object)key.getBytes());
    }

    public void put(String key, Boolean value) {
        this.put(key, RedisUtil.toByteArray(value));
    }

    public Boolean getBoolean(String key) {
        byte[] bytesValue = this.getBytes(key);
        return bytesValue == null ? null : RedisUtil.byteArrayToBoolean(bytesValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Boolean booleanValue = this.getBoolean(key);
        return booleanValue == null ? defaultValue : booleanValue;
    }

    public void put(String key, Byte value) {
        this.put(key, RedisUtil.toByteArray(value));
    }

    public Byte getByte(String key) {
        byte[] bytesValue = this.getBytes(key);
        return bytesValue == null ? null : RedisUtil.byteArrayToByte(bytesValue);
    }

    public byte getByte(String key, byte defaultValue) {
        Byte byteValue = this.getByte(key);
        return byteValue == null ? defaultValue : byteValue;
    }

    public void put(String key, Short value) {
        this.put(key, RedisUtil.toByteArray(value));
    }

    public Short getShort(String key) {
        byte[] bytesValue = this.getBytes(key);
        return bytesValue == null ? null : RedisUtil.byteArrayToShort(bytesValue);
    }

    public short getShort(String key, short defaultValue) {
        Short shortValue = this.getShort(key);
        return shortValue == null ? defaultValue : shortValue;
    }

    public void put(String key, Integer value) {
        this.put(key, RedisUtil.toByteArray(value));
    }

    public Integer getInt(String key) {
        byte[] bytesValue = this.getBytes(key);
        return bytesValue == null ? null : RedisUtil.byteArrayToInt(bytesValue);
    }

    public int getInt(String key, int defaultValue) {
        Integer integerValue = this.getInt(key);
        return integerValue == null ? defaultValue : integerValue;
    }

    public void put(String key, Long value) {
        this.put(key, RedisUtil.toByteArray(value));
    }

    public Long getLong(String key) {
        byte[] bytesValue = this.getBytes(key);
        return bytesValue == null ? null : RedisUtil.byteArrayToLong(bytesValue);
    }

    public long getLong(String key, long defaultValue) {
        Long longValue = this.getLong(key);
        return longValue == null ? defaultValue : longValue;
    }

    public void put(String key, Date value) {
        this.put(key, RedisUtil.toByteArray(value));
    }

    public Date getDate(String key) {
        byte[] bytesValue = this.getBytes(key);
        return bytesValue == null ? null : RedisUtil.byteArrayToDate(bytesValue);
    }

    public void put(String key, String value) {
        this.put(key, RedisUtil.toByteArray(value));
    }

    public String getString(String key) {
        byte[] bytesValue = this.getBytes(key);
        return bytesValue == null ? null : RedisUtil.byteArrayToStr(bytesValue);
    }

    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        return value == null ? defaultValue : value;
    }

    public void put(String key, BigDecimal value) {
        this.put(key, value, 0);
    }

    public void put(String key, BigDecimal value, int movePointRight) {
        if (value != null) {
            if (movePointRight != 0) {
                value = value.movePointRight(movePointRight);
            }
            this.put(key, value.longValue());
        } else {
            this.put(key, new byte[0]);
        }
    }

    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, 0);
    }

    public BigDecimal getBigDecimal(String key, int movePointLeft) {
        Long longValue = this.getLong(key);
        return longValue == null ? null : new BigDecimal(longValue).movePointLeft(movePointLeft);
    }

    public void putObj(String typeKey, BaseRedisObject obj) {
        if (obj != null) {
            this.put(typeKey, obj.getClass().getName());
            this.serialMap.putAll(obj.toMap());
        }
    }

    public BaseRedisObject getObj(String typeKey) {
        BaseRedisObject obj = null;
        String classType = this.getString(typeKey);
        if (classType != null) {
            try {
                Class<?> clazz = Class.forName(classType);
                obj = (BaseRedisObject)clazz.newInstance();
                obj.fromMap((Map<byte[], byte[]>)this.serialMap);
            }
            catch (Exception e) {
                throw new RuntimeException("\u83b7\u53d6redis\u5bf9\u8c61[" + classType + "]\u51fa\u9519", e);
            }
        }
        return obj;
    }
}

