/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis.spi;

import com.ec.primus.redis.api.ComJedisRedis;
import com.ec.primus.redis.util.RedisUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPipeline;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.Tuple;
import redis.clients.util.Pool;

public class ShardedJedisRedis
implements ComJedisRedis<ShardedJedis> {
    @Autowired(required=false)
    protected ShardedJedisPool shardedJedisPool;

    @Override
    public Pool<ShardedJedis> getPool() {
        return this.shardedJedisPool;
    }

    @Override
    public byte[] hget(String key, String field) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            byte[] byArray = jedis.hget(key.getBytes(), field.getBytes());
            return byArray;
        }
    }

    @Override
    public Long incrby(String key, long increment) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.incrBy(key, increment);
            return l;
        }
    }

    @Override
    public Long hdel(String key, String field) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.hdel(key.getBytes(), (byte[][])new byte[][]{field.getBytes()});
            return l;
        }
    }

    @Override
    public long hset(String key, String field, byte[] value) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            long l = jedis.hset(key.getBytes(), field.getBytes(), value);
            return l;
        }
    }

    @Override
    public boolean hsetnx(String key, String field, byte[] value) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            boolean bl = jedis.hsetnx(key.getBytes(), field.getBytes(), value).intValue() == 1;
            return bl;
        }
    }

    @Override
    public String hmset(String key, Map<byte[], byte[]> hash) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            String string = jedis.hmset(key.getBytes(), hash);
            return string;
        }
    }

    @Override
    public List<byte[]> hmget(String key, byte[] ... fields) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            List list = jedis.hmget(key.getBytes(), fields);
            return list;
        }
    }

    @Override
    public Map<byte[], byte[]> hgetAll(String key) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Map map = jedis.hgetAll(key.getBytes());
            return map;
        }
    }

    @Override
    public boolean hexists(String key, String field) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            boolean bl = jedis.hexists(key.getBytes(), field.getBytes());
            return bl;
        }
    }

    @Override
    public Long sadd(String key, byte[] value) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.sadd(key.getBytes(), (byte[][])new byte[][]{value});
            return l;
        }
    }

    @Override
    public Long scard(String key) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.scard(key);
            return l;
        }
    }

    @Override
    public boolean sismember(String key, byte[] member) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            boolean bl = jedis.sismember(key.getBytes(), member);
            return bl;
        }
    }

    @Override
    public Set<byte[]> smembers(String key) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Set set = jedis.smembers(key.getBytes());
            return set;
        }
    }

    @Override
    public Long srem(String key, byte[] members) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.srem(key.getBytes(), (byte[][])new byte[][]{members});
            return l;
        }
    }

    @Override
    public Long del(String key) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.del(key.getBytes());
            return l;
        }
    }

    @Override
    public boolean exists(String key) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            boolean bl = jedis.exists(key.getBytes());
            return bl;
        }
    }

    @Override
    public boolean zadd(String key, double score, byte[] member) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long result = jedis.zadd(key.getBytes(), score, member);
            boolean bl = result == 1L || result == 0L;
            return bl;
        }
    }

    @Override
    public Long zrem(String key, byte[] ... members) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.zrem(key.getBytes(), members);
            return l;
        }
    }

    @Override
    public Long zrem(String key, String member) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.zrem(key.getBytes(), (byte[][])new byte[][]{member.getBytes()});
            return l;
        }
    }

    @Override
    public Long zrem(String key, String ... members) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.zrem(key, members);
            return l;
        }
    }

    @Override
    public Set<byte[]> zRange(String key, long start, long end) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Set set = jedis.zrange(key.getBytes(), start, end);
            return set;
        }
    }

    @Override
    public Set<byte[]> zrevrange(String key, long start, long end) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Set set = jedis.zrevrange(key.getBytes(), start, end);
            return set;
        }
    }

    @Override
    public Set<Tuple> zrevrangeWithScore(String key, long start, long end) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Set set = jedis.zrevrangeWithScores(key.getBytes(), start, end);
            return set;
        }
    }

    @Override
    public Set<byte[]> zangeByScore(String key, String min, String max) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Set set = jedis.zrangeByScore(key.getBytes(), min.getBytes(), max.getBytes());
            return set;
        }
    }

    @Override
    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Set set = jedis.zrangeWithScores(key.getBytes(), start, end);
            return set;
        }
    }

    @Override
    public Long zCard(String key) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.zcard(key.getBytes());
            return l;
        }
    }

    @Override
    public Double zscore(String key, byte[] member) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Double d = jedis.zscore(key.getBytes(), member);
            return d;
        }
    }

    @Override
    public Integer zscoreToInt(String key, byte[] member) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Double d = jedis.zscore(key.getBytes(), member);
            Integer n = d == null ? null : Integer.valueOf(d.intValue());
            return n;
        }
    }

    @Override
    public Long zscoreToLong(String key, byte[] member) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Double d = jedis.zscore(key.getBytes(), member);
            Long l = d == null ? null : Long.valueOf(d.longValue());
            return l;
        }
    }

    @Override
    public Long zrank(String key, byte[] member) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.zrank(key.getBytes(), member);
            return l;
        }
    }

    @Override
    public Double zincrby(String key, double score, byte[] member) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Double d = jedis.zincrby(key.getBytes(), score, member);
            return d;
        }
    }

    @Override
    public Long rpush(String key, byte[] value) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.rpush(key.getBytes(), (byte[][])new byte[][]{value});
            return l;
        }
    }

    @Override
    public Long rpush(String key, byte[] ... strings) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.rpush(key.getBytes(), strings);
            return l;
        }
    }

    @Override
    public Long lpush(String key, byte[] ... strings) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.lpush(key.getBytes(), strings);
            return l;
        }
    }

    @Override
    public Long lpush(String key, String ... strings) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.lpush(key, strings);
            return l;
        }
    }

    @Override
    public Long rpush(String key, String ... strings) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.rpush(key, strings);
            return l;
        }
    }

    @Override
    public String ltrim(String key, long start, long end) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            String string = jedis.ltrim(key.getBytes(), start, end);
            return string;
        }
    }

    @Override
    public List<byte[]> lrange(String key, long start, long end) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            List list = jedis.lrange(key.getBytes(), start, end);
            return list;
        }
    }

    @Override
    public long llen(String key) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            long l = jedis.llen(key.getBytes());
            return l;
        }
    }

    @Override
    public byte[] lpop(String key) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            byte[] byArray = jedis.lpop(key.getBytes());
            return byArray;
        }
    }

    @Override
    public Set<byte[]> zrevrangeByScore(String key, byte[] max, byte[] min) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Set set = jedis.zrevrangeByScore(key.getBytes(), max, min);
            return set;
        }
    }

    @Override
    public Set<byte[]> zrevrangeByScore(String key, String max, String min) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Set set = jedis.zrevrangeByScore(key.getBytes(), max.getBytes(), min.getBytes());
            return set;
        }
    }

    @Override
    public Set<byte[]> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Set set = jedis.zrevrangeByScore(key.getBytes(), max.getBytes(), min.getBytes(), offset, count);
            return set;
        }
    }

    @Override
    public long zcount(String key, String min, String max) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long count = jedis.zcount(key.getBytes(), min.getBytes(), max.getBytes());
            long l = count == null ? 0L : count;
            return l;
        }
    }

    @Override
    public Long zremrangeByScore(String key, String start, String end) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.zremrangeByScore(key.getBytes(), start.getBytes(), end.getBytes());
            return l;
        }
    }

    @Override
    public Long zremrangeByRank(String key, long start, long end) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.zremrangeByRank(key.getBytes(), start, end);
            return l;
        }
    }

    @Override
    public Long zcount(String key, double min, double max) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.zcount(key.getBytes(), min, max);
            return l;
        }
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Set set = jedis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
    }

    @Override
    public Set<String> zrangeByScore(String key, String min, String max) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Set set = jedis.zrangeByScore(key, min, max);
            return set;
        }
    }

    @Override
    public Set<String> zrangeByScore(String key, long min, long max) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Set set = jedis.zrangeByScore(key, (double)min, (double)max);
            return set;
        }
    }

    @Override
    public void expire(String key, int seconds) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            jedis.expire(key.getBytes(), seconds);
        }
    }

    @Override
    public void expireAt(String key, Long unixTime) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            jedis.expireAt(key.getBytes(), unixTime.longValue());
        }
    }

    @Override
    public List<Object> pipeHgetall(List<String> ids) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String id : ids) {
                jedisPipeline.hgetAll(id.getBytes());
            }
            List list = jedisPipeline.syncAndReturnAll();
            return list;
        }
    }

    @Override
    public void pipeSadd(String key, String ... members) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            jedisPipeline.sadd(key, members);
            jedisPipeline.syncAndReturnAll();
        }
    }

    @Override
    public void pipeZadd(String key, double score, List<String> members) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String member : members) {
                jedisPipeline.zadd(key.getBytes(), score, member.getBytes());
            }
            jedisPipeline.syncAndReturnAll();
        }
    }

    @Override
    public List<Object> pipeZcard(List<String> ids) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String id : ids) {
                jedisPipeline.zcard(id.getBytes());
            }
            List list = jedisPipeline.syncAndReturnAll();
            return list;
        }
    }

    @Override
    public void pipeHmset(String key, List<Map<byte[], byte[]>> hashs) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (Map<byte[], byte[]> hash : hashs) {
                jedisPipeline.hmset(key.getBytes(), hash);
            }
            jedisPipeline.syncAndReturnAll();
        }
    }

    @Override
    public Long hincrBy(String key, byte[] field, long value) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.hincrBy(key.getBytes(), field, value);
            return l;
        }
    }

    @Override
    public byte[] get(String key) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            byte[] byArray = jedis.get(key.getBytes());
            return byArray;
        }
    }

    @Override
    public void set(String key, byte[] value) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            jedis.set(key.getBytes(), value);
        }
    }

    @Override
    public void setex(String key, int seconds, byte[] value) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            jedis.setex(key.getBytes(), seconds, value);
        }
    }

    @Override
    public boolean setnx(String key, byte[] value) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long r = jedis.setnx(key.getBytes(), value);
            boolean bl = r != null && r.intValue() == 1;
            return bl;
        }
    }

    @Override
    public Long getTTL(String key) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.ttl(key.getBytes());
            return l;
        }
    }

    @Override
    public Long incr(String key) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.incr(key.getBytes());
            return l;
        }
    }

    @Override
    public Long decr(String key) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.decr(key.getBytes());
            return l;
        }
    }

    @Override
    public Long zrevrank(String key, byte[] member) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.zrevrank(key.getBytes(), member);
            return l;
        }
    }

    @Override
    public List<Object> pipeRpop(byte[] key, long size) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            int i = 0;
            while ((long)i < size) {
                jedisPipeline.rpop(key);
                ++i;
            }
            List list = jedisPipeline.syncAndReturnAll();
            return list;
        }
    }

    @Override
    public Long lrem(String key, long count, byte[] value) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.lrem(key.getBytes(), count, value);
            return l;
        }
    }

    @Override
    public List<Object> pipeGet(List<String> keys) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String key : keys) {
                jedisPipeline.get(key.getBytes());
            }
            List list = jedisPipeline.syncAndReturnAll();
            return list;
        }
    }

    @Override
    public List<Object> pipeHget(Collection<String> keys, String field) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String key : keys) {
                jedisPipeline.hget(key, field);
            }
            List list = jedisPipeline.syncAndReturnAll();
            return list;
        }
    }

    @Override
    public void pipeHincrBy(Map<String, Integer> keyToCounts, String field) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (Map.Entry<String, Integer> entry : keyToCounts.entrySet()) {
                Integer value = entry.getValue();
                if (value == null || value == 0) continue;
                jedisPipeline.hincrBy(entry.getKey(), field, (long)value.intValue());
            }
            jedisPipeline.sync();
        }
    }

    @Override
    public void pipeZrem(String key, Collection<String> members) {
        if (CollectionUtils.isEmpty(members)) {
            return;
        }
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            jedisPipeline.zrem(key, members.toArray(new String[members.size()]));
            jedisPipeline.sync();
        }
    }

    @Override
    public void pipeSet(List<String> keys, List<byte[]> values) {
        assert (CollectionUtils.isNotEmpty(keys) && CollectionUtils.isNotEmpty(values) && keys.size() == values.size());
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (int i = 0; i < keys.size(); ++i) {
                String key = keys.get(i);
                jedisPipeline.set(RedisUtil.toByteArray(key), values.get(i));
            }
            jedisPipeline.sync();
        }
    }

    @Override
    public void pipeHSet(Map<String, String> keyToValue, String field) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (Map.Entry<String, String> entry : keyToValue.entrySet()) {
                jedisPipeline.hset(entry.getKey(), field, entry.getValue());
            }
            jedisPipeline.sync();
        }
    }

    public void jedisCallback(Consumer<ShardedJedis> callback) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            callback.accept(jedis);
        }
    }

    public <T> T returnableCallback(Function<ShardedJedis, T> callback) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            T t = callback.apply(jedis);
            return t;
        }
    }

    @Override
    public void pipeLpush(byte[] key, byte[] ... values) {
        if (ArrayUtils.isNotEmpty((Object[])values)) {
            try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
                ShardedJedisPipeline pipelined = jedis.pipelined();
                pipelined.lpush(key, values);
                pipelined.sync();
            }
        }
    }

    @Override
    public void pipeLpush(Collection<byte[]> keys, Collection<byte[]> values) {
        if (CollectionUtils.isNotEmpty(keys) && CollectionUtils.isNotEmpty(values) && keys.size() == values.size()) {
            try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
                ShardedJedisPipeline pipelined = jedis.pipelined();
                Iterator<byte[]> keyIterator = keys.iterator();
                Iterator<byte[]> valueIterator = values.iterator();
                IntStream.range(0, keys.size()).forEach(i -> pipelined.lpush((byte[])keyIterator.next(), (byte[][])new byte[][]{(byte[])valueIterator.next()}));
                pipelined.syncAndReturnAll();
            }
        }
    }

    @Override
    public Long persist(String key) {
        try (ShardedJedis jedis = this.shardedJedisPool.getResource();){
            Long l = jedis.persist(key);
            return l;
        }
    }

    public List<Object> pipeZrange(List<String> keys) {
        try (ShardedJedis jedis = (ShardedJedis)this.getPool().getResource();){
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String key : keys) {
                jedisPipeline.zrange(key, 0L, -1L);
            }
            List list = jedisPipeline.syncAndReturnAll();
            return list;
        }
    }

    public void setShardedJedisPool(ShardedJedisPool shardedJedisPool) {
        this.shardedJedisPool = shardedJedisPool;
    }
}

