/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis.trans.impl.convertor;

import com.ec.primus.redis.trans.ConvertorRegistry;
import com.ec.primus.redis.trans.DataItem;
import com.ec.primus.redis.trans.ValueConvertor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMultiValueConvertor<V>
implements ValueConvertor<V> {
    private ConvertorRegistry convertorRegistry;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected ConvertorRegistry getConvertorRegistry() {
        return this.convertorRegistry;
    }

    public AbstractMultiValueConvertor(ConvertorRegistry convertorRegistry) {
        this.convertorRegistry = convertorRegistry;
    }

    protected DataItem[] resolveItems(String key, Object value) {
        return this.resolveItems(null, key, value);
    }

    protected DataItem[] resolveItems(String prefix, String propKey, Object value) {
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            propKey = prefix + "." + propKey;
        }
        if (value == null) {
            return null;
        }
        ValueConvertor<Object> convertor = this.getConvertorRegistry().findConvertor(value.getClass());
        if (convertor == null) {
            this.logger.warn("prop[name={},type={}] convertor not found", (Object)propKey, (Object)value.getClass().getSimpleName());
            throw new RuntimeException("Converter not fund for:" + value.getClass());
        }
        return convertor.toRedisData(propKey, value);
    }
}

