/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis.trans.impl.convertor;

import com.ec.primus.redis.trans.BeanRegistry;
import com.ec.primus.redis.trans.ConvertorMatcher;
import com.ec.primus.redis.trans.ConvertorRegistry;
import com.ec.primus.redis.trans.DataItem;
import com.ec.primus.redis.trans.PropertyDescriptorExtends;
import com.ec.primus.redis.trans.RedisObject;
import com.ec.primus.redis.trans.ValueConvertor;
import com.ec.primus.redis.trans.impl.convertor.AbstractMultiValueConvertor;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ReflectionUtils;

public class BeanConvertor
extends AbstractMultiValueConvertor<Object> {
    public static final ConvertorMatcher MATCHER = new ConvertorMatcher(){

        @Override
        public boolean isMatch(Class clazz) {
            return RedisObject.class.isAssignableFrom(clazz);
        }
    };
    private BeanRegistry beanRegistry;

    public BeanConvertor(ConvertorRegistry convertorRegistry, BeanRegistry beanRegistry) {
        super(convertorRegistry);
        this.beanRegistry = beanRegistry;
    }

    @Override
    public DataItem[] toRedisData(String key, Object val) {
        List<DataItem> items = this.resolveBean(key, val);
        return items.toArray(new DataItem[items.size()]);
    }

    private List<DataItem> resolveBean(String prefix, Object object) {
        if (this.beanRegistry == null) {
            return Lists.newArrayList();
        }
        List<PropertyDescriptorExtends> pdes = this.beanRegistry.findProperties(object.getClass());
        boolean usePrefix = StringUtils.isNotBlank((CharSequence)prefix);
        ArrayList data = Lists.newArrayList();
        for (PropertyDescriptorExtends pde : pdes) {
            Class propertyType = pde.getPropertyType();
            ValueConvertor<Object> convertor = this.getConvertorRegistry().findConvertor(propertyType);
            Object val = this.getValue(object, pde);
            if (val == null) continue;
            String name = pde.getName();
            name = usePrefix ? prefix + "." + name : name;
            DataItem[] items = convertor.toRedisData(name, val);
            data.addAll(Arrays.asList(items));
        }
        return data;
    }

    private void setValue(Object pojo, PropertyDescriptorExtends pde, Object value) {
        if (value == null) {
            return;
        }
        Method writeMethod = pde.getWriteMethod();
        if (writeMethod == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("ro[type={}] prop[name={}] not found setter", pojo.getClass(), (Object)pde.getName());
            }
            return;
        }
        ReflectionUtils.invokeMethod((Method)writeMethod, (Object)pojo, (Object[])new Object[]{value});
    }

    private Object getValue(Object pojo, PropertyDescriptorExtends pde) {
        Method readMethod = pde.getReadMethod();
        if (readMethod == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("ro[type={}] prop[name={}] not found getter", pojo.getClass(), (Object)pde.getName());
            }
            return null;
        }
        return ReflectionUtils.invokeMethod((Method)readMethod, (Object)pojo);
    }

    @Override
    public Object toValue(Class<Object> clazz, String prefix, DataItem[] redisData) {
        if (this.beanRegistry == null) {
            return null;
        }
        Object obj = this.beanRegistry.newBeanInstance(clazz);
        Map<String, DataItem[]> classifyItems = this.classify(redisData);
        for (PropertyDescriptorExtends pde : this.beanRegistry.findProperties(clazz)) {
            String name = pde.getName();
            DataItem[] data = classifyItems.get(name);
            Class type = pde.getPropertyType();
            Object value = this.getConvertorRegistry().findConvertor(type).toValue(type, name, data);
            this.setValue(obj, pde, value);
        }
        return obj;
    }

    private Map<String, DataItem[]> classify(DataItem[] items) {
        HashMap result = Maps.newHashMap();
        if (items == null || items.length == 0) {
            return result;
        }
        ListMultimap map = MultimapBuilder.hashKeys().arrayListValues().build();
        for (DataItem item : items) {
            map.put((Object)item.getKey().split(".")[0], (Object)item);
        }
        for (Map.Entry entry : map.asMap().entrySet()) {
            result.put(entry.getKey(), ((Collection)entry.getValue()).toArray(new DataItem[((Collection)entry.getValue()).size()]));
        }
        return result;
    }
}

