/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis.trans.impl.convertor;

import com.ec.primus.redis.trans.ConvertorMatcher;
import com.ec.primus.redis.trans.DataItem;
import com.ec.primus.redis.trans.ValueConvertor;
import org.apache.commons.lang3.EnumUtils;

public class EnumConvertor<E extends Enum<E>>
implements ValueConvertor<E> {
    public static final ConvertorMatcher MARCHER = new ConvertorMatcher(){

        @Override
        public boolean isMatch(Class clazz) {
            return Enum.class.isAssignableFrom(clazz);
        }
    };

    @Override
    public DataItem[] toRedisData(String key, Enum val) {
        if (val == null) {
            return new DataItem[0];
        }
        return new DataItem[]{new DataItem(key, val.name().getBytes())};
    }

    @Override
    public E toValue(Class<E> clazz, String prefix, DataItem[] redisData) {
        if (redisData == null || redisData.length == 0) {
            return null;
        }
        String enumName = new String(redisData[0].getData());
        return (E)EnumUtils.getEnum(clazz, (String)enumName);
    }
}

