/*
 * Decompiled with CFR 0.152.
 */
package com.ec.primus.redis.util;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public final class RedisUtil {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public static byte[] toByteArray(Serializable id) {
        return id.toString().getBytes();
    }

    public static byte[] currentTs() {
        return RedisUtil.toByteArray(System.currentTimeMillis());
    }

    public static byte[] toByteArray(Boolean value) {
        return value == null ? new byte[]{} : (value != false ? "1" : "0").getBytes();
    }

    public static byte[] toByteArray(Byte value) {
        return value == null ? new byte[]{} : Byte.toString(value).getBytes();
    }

    public static byte[] toByteArray(Short value) {
        return value == null ? new byte[]{} : Short.toString(value).getBytes();
    }

    public static byte[] toByteArray(Integer value) {
        return value == null ? new byte[]{} : Integer.toString(value).getBytes();
    }

    public static byte[] toByteArray(Long value) {
        return value == null ? new byte[]{} : Long.toString(value).getBytes();
    }

    public static byte[] toByteArray(Date value) {
        if (value == null) {
            return null;
        }
        return Long.toString(value.getTime()).getBytes();
    }

    public static byte[] toByteArray(String value) {
        if (value == null) {
            return new byte[0];
        }
        return value.getBytes(DEFAULT_CHARSET);
    }

    public static byte[] toByteArray6(BigDecimal value) {
        return value == null ? new byte[]{} : RedisUtil.toByteArray(value.movePointRight(6).intValue());
    }

    public static BigDecimal byteArrayToBigDecimal6(byte[] b) {
        int intValue = RedisUtil.byteArrayToInt(b);
        return new BigDecimal(intValue).movePointLeft(6);
    }

    public static byte[][] toByteArray(int[] value) {
        byte[][] result = new byte[value.length][];
        for (int i = 0; i < value.length; ++i) {
            result[i] = RedisUtil.toByteArray(value[i]);
        }
        return result;
    }

    public static byte[][] toByteArray(List<Integer> list) {
        byte[][] result = new byte[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = RedisUtil.toByteArray(list.get(i));
        }
        return result;
    }

    public static byte[][] ListBytetoByteArray(List<byte[]> list) {
        byte[][] result = new byte[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = RedisUtil.toByteArray((Serializable)list.get(i));
        }
        return result;
    }

    public static byte[][] toByteArray(long[] value) {
        byte[][] result = new byte[value.length][];
        for (int i = 0; i < value.length; ++i) {
            result[i] = RedisUtil.toByteArray(value[i]);
        }
        return result;
    }

    public static Integer byteArrayToInt(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : Integer.valueOf(Integer.parseInt(new String(b)));
    }

    public static Long byteArrayToLong(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : Long.valueOf(Long.parseLong(new String(b)));
    }

    public static Short byteArrayToShort(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : Short.valueOf(Short.parseShort(new String(b)));
    }

    public static Byte byteArrayToByte(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : Byte.valueOf(Byte.parseByte(new String(b)));
    }

    public static Boolean byteArrayToBoolean(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : Boolean.valueOf("1".equals(new String(b)));
    }

    public static String byteArrayToStr(byte[] b) {
        return ArrayUtils.isEmpty((byte[])b) ? null : new String(b, DEFAULT_CHARSET);
    }

    public static java.sql.Date byteArrayToDate(byte[] bytesValue) {
        long longValue = RedisUtil.byteArrayToLong(bytesValue);
        return new java.sql.Date(longValue);
    }

    public static int[] bytesSetToIntArray(Set<byte[]> bytesSet) {
        if (bytesSet == null || bytesSet.isEmpty()) {
            return null;
        }
        int[] userIdArr = new int[bytesSet.size()];
        int count = 0;
        for (byte[] userIdBytes : bytesSet) {
            userIdArr[count] = RedisUtil.byteArrayToInt(userIdBytes);
            ++count;
        }
        return userIdArr;
    }

    public static List<Integer> bytesSetToIntList(Set<byte[]> bytesSet) {
        if (bytesSet == null || bytesSet.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList<Integer> userIdArr = new ArrayList<Integer>(bytesSet.size());
        for (byte[] userIdBytes : bytesSet) {
            userIdArr.add(RedisUtil.byteArrayToInt(userIdBytes));
        }
        return userIdArr;
    }

    public static Long[] bytesSetToLongArray(Set<byte[]> bytesSet) {
        if (CollectionUtils.isEmpty(bytesSet)) {
            return null;
        }
        Long[] idArr = new Long[bytesSet.size()];
        int count = 0;
        for (byte[] userIdBytes : bytesSet) {
            idArr[count] = RedisUtil.byteArrayToLong(userIdBytes);
            ++count;
        }
        return idArr;
    }

    public static List<Long> bytesSetToLongList(Set<byte[]> bytesSet) {
        if (CollectionUtils.isEmpty(bytesSet)) {
            return Lists.newArrayList();
        }
        ArrayList<Long> idList = new ArrayList<Long>(bytesSet.size());
        for (byte[] userIdBytes : bytesSet) {
            idList.add(RedisUtil.byteArrayToLong(userIdBytes));
        }
        return idList;
    }

    public static List<String> bytesSetToStringList(Set<byte[]> bytesSet) {
        if (CollectionUtils.isEmpty(bytesSet)) {
            return new ArrayList<String>();
        }
        ArrayList<String> strings = new ArrayList<String>(bytesSet.size());
        for (byte[] bytes : bytesSet) {
            strings.add(RedisUtil.byteArrayToStr(bytes));
        }
        return strings;
    }

    public static String[] bytesSetToStringArray(Set<byte[]> bytesSet) {
        if (bytesSet == null || bytesSet.isEmpty()) {
            return null;
        }
        String[] userIdArr = new String[bytesSet.size()];
        int count = 0;
        for (byte[] userIdBytes : bytesSet) {
            userIdArr[count] = RedisUtil.byteArrayToStr(userIdBytes);
            ++count;
        }
        return userIdArr;
    }

    public static List<Long> stringSetToLongList(Set<String> stringSet) {
        if (CollectionUtils.isEmpty(stringSet)) {
            return null;
        }
        ArrayList<Long> idList = new ArrayList<Long>(stringSet.size());
        for (String s : stringSet) {
            idList.add(Long.valueOf(s));
        }
        return idList;
    }

    public static List<String> stringSetToStringList(Set<String> stringSet) {
        if (CollectionUtils.isEmpty(stringSet)) {
            return new ArrayList<String>();
        }
        ArrayList<String> idList = new ArrayList<String>(stringSet.size());
        for (String s : stringSet) {
            idList.add(String.valueOf(s));
        }
        return idList;
    }
}

