/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.customer.account.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.falcon.sdk.customer.account.builder.AccountQueryBuilder;
import com.ehking.falcon.sdk.customer.account.builder.RechargeQueryBuilder;
import com.ehking.falcon.sdk.customer.account.builder.SubrogateQueryBuilder;
import com.ehking.falcon.sdk.exception.ResponseException;
import com.ehking.falcon.sdk.exception.UnknownException;
import com.ehking.falcon.sdk.executer.Executer;
import com.ehking.falcon.sdk.executer.ResultListener;
import com.ehking.falcon.sdk.util.CipherWrapper;
import com.ehking.falcon.sdk.util.ConfigurationUtils;
import com.ehking.falcon.sdk.util.Constants;
import com.ehking.falcon.sdk.util.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(AccountExecuter.class);

    public void bothAccountQuery(AccountQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getAccountQueryUrl(), requestData);
            LOGGER.info("responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.debug("responseStr:[" + responseData + "]");
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request account query exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothMerchantAccountQuery(AccountQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.info("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getMerchantAccountQueryUrl(), requestData);
            LOGGER.info("responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.debug("responseStr:[" + responseData + "]");
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request account query exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothSubrogateQuery(SubrogateQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getAccountSubrogateQueryUrl(), requestData);
            LOGGER.info("responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.debug("responseStr:[" + responseData + "]");
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request subrogate query exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothRechargeQuery(RechargeQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getRechargeQueryUrl(), requestData);
            LOGGER.info("responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request subrogate query exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

