/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.customer.auth.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.falcon.sdk.builder.BuilderSupport;
import com.ehking.falcon.sdk.util.CipherWrapper;
import com.ehking.falcon.sdk.util.ConfigurationUtils;
import com.ehking.falcon.sdk.util.RSAUtils;
import com.ehking.falcon.sdk.util.SignUtils;
import org.apache.commons.lang3.StringUtils;

public final class LivePhotoAuthBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String name;
    private String idCardNumber;
    private String redirectUrl;
    private String notifyUrl;

    public LivePhotoAuthBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public LivePhotoAuthBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public LivePhotoAuthBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public LivePhotoAuthBuilder setIdCardNumber(String idCardNumber) {
        this.idCardNumber = idCardNumber;
        return this;
    }

    public LivePhotoAuthBuilder setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public LivePhotoAuthBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        json.put("requestId", (Object)this.requestId);
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            json.put("name", (Object)this.name);
        }
        if (StringUtils.isNotBlank((CharSequence)this.idCardNumber)) {
            json.put("idCardNumber", (Object)this.idCardNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.redirectUrl)) {
            json.put("redirectUrl", (Object)this.redirectUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.name, (String)"")).append(StringUtils.defaultString((String)this.idCardNumber, (String)"")).append(StringUtils.defaultString((String)this.redirectUrl, (String)"")).append(StringUtils.defaultString((String)this.notifyUrl, (String)""));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

