/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.customer.auth.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.falcon.sdk.customer.auth.builder.LivePhotoAuthBuilder;
import com.ehking.falcon.sdk.exception.ResponseException;
import com.ehking.falcon.sdk.exception.UnknownException;
import com.ehking.falcon.sdk.executer.Executer;
import com.ehking.falcon.sdk.executer.ResultListener;
import com.ehking.falcon.sdk.util.CipherWrapper;
import com.ehking.falcon.sdk.util.ConfigurationUtils;
import com.ehking.falcon.sdk.util.Constants;
import com.ehking.falcon.sdk.util.HttpClientUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivePhotoAuthExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(LivePhotoAuthExecuter.class);

    public void bothOrder(LivePhotoAuthBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getLivePhotoAuthUrl(), requestData);
                LOGGER.info("responseStr :{}", (Object)responseStr);
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.debug("responseStr:[" + responseData + "]");
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (StringUtils.isNotEmpty((CharSequence)responseData.getString(Constants.FAILED))) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }
}

