/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.customer.insurence.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.falcon.sdk.customer.insurence.builder.CreateInsurenceBuilder;
import com.ehking.falcon.sdk.customer.insurence.builder.QueryInsurenceBuilder;
import com.ehking.falcon.sdk.exception.ResponseException;
import com.ehking.falcon.sdk.exception.UnknownException;
import com.ehking.falcon.sdk.executer.Executer;
import com.ehking.falcon.sdk.executer.ResultListener;
import com.ehking.falcon.sdk.util.CipherWrapper;
import com.ehking.falcon.sdk.util.ConfigurationUtils;
import com.ehking.falcon.sdk.util.Constants;
import com.ehking.falcon.sdk.util.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsurenceExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(InsurenceExecuter.class);

    public void bothCreateInsurance(CreateInsurenceBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCreateInsuranceUrl(), requestData);
            LOGGER.info("responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.debug("responseStr:[" + responseData + "]");
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request account query exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothQueryInsurance(QueryInsurenceBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getQueryInsuranceUrl(), requestData);
            LOGGER.info("responseStr :{}", (Object)responseStr);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                throw new ResponseException(responseData);
            }
            responseData = CipherWrapper.bothDecryptWrap(responseData);
            LOGGER.debug("responseStr:[" + responseData + "]");
            this.bothVerifyHmacOrder(responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
            listener.success(responseData);
        }
        catch (Exception e) {
            LOGGER.error("request insurence query exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

