/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.customer.payorder.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.falcon.sdk.builder.BuilderSupport;
import com.ehking.falcon.sdk.customer.payorder.entity.MerchantSubOrder;
import com.ehking.falcon.sdk.customer.payorder.entity.TransferSceneReportInfo;
import com.ehking.falcon.sdk.util.CipherWrapper;
import com.ehking.falcon.sdk.util.RSAUtils;
import java.util.LinkedList;
import java.util.List;

public final class MerchantOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String payeeType;
    private String appId;
    private String subrogateId;
    private String notifyUrl;
    private List<MerchantSubOrder> subOrders = new LinkedList<MerchantSubOrder>();
    private List<TransferSceneReportInfo> transferSceneReportInfos = new LinkedList<TransferSceneReportInfo>();

    public MerchantOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public MerchantOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public MerchantOrderBuilder setPayeeType(String payeeType) {
        this.payeeType = payeeType;
        return this;
    }

    public MerchantOrderBuilder setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public MerchantOrderBuilder setSubrogateId(String subrogateId) {
        this.subrogateId = subrogateId;
        return this;
    }

    public MerchantOrderBuilder addMerchantSubOrder(MerchantSubOrder subOrder) {
        this.subOrders.add(subOrder);
        return this;
    }

    public MerchantOrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public MerchantOrderBuilder addTransferSceneReportInfo(TransferSceneReportInfo transferSceneReportInfo) {
        this.transferSceneReportInfos.add(transferSceneReportInfo);
        return this;
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

