/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.customer.payorder.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.falcon.sdk.builder.BuilderSupport;
import com.ehking.falcon.sdk.customer.payorder.entity.SubOrder;
import com.ehking.falcon.sdk.util.CipherWrapper;
import com.ehking.falcon.sdk.util.RSAUtils;
import java.util.LinkedList;
import java.util.List;

public final class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String subrogateId;
    private String appId;
    private String requestId;
    private String paymentChannel;
    private String notifyUrl;
    private List<SubOrder> subOrders = new LinkedList<SubOrder>();

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBuilder setSubrogateId(String subrogateId) {
        this.subrogateId = subrogateId;
        return this;
    }

    public OrderBuilder setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public OrderBuilder setPaymentChannel(String paymentChannel) {
        this.paymentChannel = paymentChannel;
        return this;
    }

    public OrderBuilder addSubOrder(SubOrder subOrder) {
        this.subOrders.add(subOrder);
        return this;
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

