/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.customer.payorder.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.falcon.sdk.builder.BuilderSupport;
import com.ehking.falcon.sdk.util.CipherWrapper;
import com.ehking.falcon.sdk.util.ConfigurationUtils;
import com.ehking.falcon.sdk.util.RSAUtils;
import com.ehking.falcon.sdk.util.SignUtils;
import org.apache.commons.lang3.StringUtils;

public final class OrderVoucherBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String platformRequestId;
    private String subOrderNo;

    public OrderVoucherBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderVoucherBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderVoucherBuilder setPlatformRequestId(String platformRequestId) {
        this.platformRequestId = platformRequestId;
        return this;
    }

    public OrderVoucherBuilder setSubOrderNo(String subOrderNo) {
        this.subOrderNo = subOrderNo;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.platformRequestId)) {
            json.put("platformRequestId", (Object)this.platformRequestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.subOrderNo)) {
            json.put("subOrderNo", (Object)this.subOrderNo);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.platformRequestId, (String)"")).append(StringUtils.defaultString((String)this.subOrderNo, (String)""));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

