/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.customer.payorder.executer;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ehking.falcon.sdk.customer.payorder.builder.InvoiceQueryBuilder;
import com.ehking.falcon.sdk.customer.payorder.builder.OrderInvoiceBuilder;
import com.ehking.falcon.sdk.customer.payorder.builder.OrderInvoiceQueryBuilder;
import com.ehking.falcon.sdk.exception.ResponseException;
import com.ehking.falcon.sdk.exception.UnknownException;
import com.ehking.falcon.sdk.executer.Executer;
import com.ehking.falcon.sdk.executer.ResultListener;
import com.ehking.falcon.sdk.util.CipherWrapper;
import com.ehking.falcon.sdk.util.ConfigurationUtils;
import com.ehking.falcon.sdk.util.Constants;
import com.ehking.falcon.sdk.util.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderInvoiceExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(OrderInvoiceExecuter.class);

    public void bothInvoiceOrder(OrderInvoiceBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getPayOrderInvoiceUrl(), requestData);
                LOGGER.info("responseStr :{}", (Object)responseStr);
                JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.debug("responseStr:[" + responseData + "]");
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.ACCEPT.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.processing(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.failure(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothInvoiceOrderQuery(OrderInvoiceQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getPayOrderInvoiceQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("responseStr:[" + responseStr + "]");
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order query exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(data);
        } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status) || Constants.ERROR.equals(status)) {
            listener.failure(data);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(data);
        } else if (Constants.ACCEPT.equals(status)) {
            listener.processing(data);
        } else {
            throw new ResponseException(data);
        }
    }

    public void bothInvoiceRecordQuery(InvoiceQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("requestData:[" + requestData + "]");
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getInvoiceRecordQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject((String)responseStr, (Feature[])new Feature[]{Feature.SortFeidFastMatch});
            String status = responseData.getString(Constants.STATUS);
            if (Constants.ERROR.equals(status)) {
                LOGGER.debug("decrypt responseData : {}", (Object)responseData);
                throw new ResponseException(responseData);
            }
            LOGGER.debug("responseStr:[" + responseStr + "]");
            this.bothCipherCallback(responseData, listener);
        }
        catch (Exception e) {
            LOGGER.error("request order query exception", (Throwable)e);
            throw new UnknownException(e);
        }
    }
}

