/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.customer.signup.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.falcon.sdk.builder.BuilderSupport;
import com.ehking.falcon.sdk.util.CipherWrapper;
import com.ehking.falcon.sdk.util.ConfigurationUtils;
import com.ehking.falcon.sdk.util.RSAUtils;
import com.ehking.falcon.sdk.util.SignUtils;
import org.apache.commons.lang3.StringUtils;

public final class SignUpBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String signatoryName;
    private String signatoryIdNumber;
    private String signatoryMobile;
    private String signatoryIdPhotoFront;
    private String signatoryIdPhotoBack;

    public SignUpBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public SignUpBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public SignUpBuilder setSignatoryName(String signatoryName) {
        this.signatoryName = signatoryName;
        return this;
    }

    public SignUpBuilder setSignatoryIdNumber(String signatoryIdNumber) {
        this.signatoryIdNumber = signatoryIdNumber;
        return this;
    }

    public SignUpBuilder setSignatoryMobile(String signatoryMobile) {
        this.signatoryMobile = signatoryMobile;
        return this;
    }

    public SignUpBuilder setSignatoryIdPhotoFront(String signatoryIdPhotoFront) {
        this.signatoryIdPhotoFront = signatoryIdPhotoFront;
        return this;
    }

    public SignUpBuilder setSignatoryIdPhotoBack(String signatoryIdPhotoBack) {
        this.signatoryIdPhotoBack = signatoryIdPhotoBack;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        json.put("requestId", (Object)this.requestId);
        if (StringUtils.isNotBlank((CharSequence)this.signatoryName)) {
            json.put("signatoryName", (Object)this.signatoryName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.signatoryIdNumber)) {
            json.put("signatoryIdNumber", (Object)this.signatoryIdNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.signatoryMobile)) {
            json.put("signatoryMobile", (Object)this.signatoryMobile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.signatoryIdPhotoFront)) {
            json.put("signatoryIdPhotoFront", (Object)this.signatoryIdPhotoFront);
        }
        if (StringUtils.isNotBlank((CharSequence)this.signatoryIdPhotoBack)) {
            json.put("signatoryIdPhotoBack", (Object)this.signatoryIdPhotoBack);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.signatoryName, (String)"")).append(StringUtils.defaultString((String)this.signatoryIdNumber, (String)"")).append(StringUtils.defaultString((String)this.signatoryMobile, (String)"")).append(StringUtils.defaultString((String)this.signatoryIdPhotoFront, (String)"")).append(StringUtils.defaultString((String)this.signatoryIdPhotoBack, (String)""));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

