/*
 * Decompiled with CFR 0.152.
 */
package com.ehking.falcon.sdk.customer.signup.builder;

import com.alibaba.fastjson.JSONObject;
import com.ehking.falcon.sdk.builder.BuilderSupport;
import com.ehking.falcon.sdk.util.CipherWrapper;
import com.ehking.falcon.sdk.util.ConfigurationUtils;
import com.ehking.falcon.sdk.util.RSAUtils;
import com.ehking.falcon.sdk.util.SignUtils;
import org.apache.commons.lang3.StringUtils;

public final class SignUpQueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String userId;
    private String signatoryIdNumber;

    public SignUpQueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public SignUpQueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public SignUpQueryBuilder setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public SignUpQueryBuilder setSignatoryIdNumber(String signatoryIdNumber) {
        this.signatoryIdNumber = signatoryIdNumber;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        json.put("requestId", (Object)this.requestId);
        if (StringUtils.isNotBlank((CharSequence)this.userId)) {
            json.put("userId", (Object)this.userId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.signatoryIdNumber)) {
            json.put("signatoryIdNumber", (Object)this.signatoryIdNumber);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.userId, (String)"")).append(StringUtils.defaultString((String)this.signatoryIdNumber, (String)""));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

